/*
 * Decompiled with CFR 0.152.
 */
package com.boss.health.indicator.ui;

import com.boss.health.indicator.BossHealthIndicatorPlugin;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import net.runelite.client.ui.components.colorpicker.RuneliteColorPicker;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;

public class ColorPicker {
    private static final ImageIcon FILL_COLOR_ICON;
    private static final ImageIcon FILL_COLOR_HOVER_ICON;
    private static final ImageIcon NO_FILL_COLOR_ICON;
    private static final ImageIcon NO_FILL_COLOR_HOVER_ICON;
    private static final int DEFAULT_FILL_OPACITY = 75;
    private Color color;
    private Runnable onChanged;
    private BossHealthIndicatorPlugin plugin;
    private JLabel label;

    public ColorPicker(final Color color, BossHealthIndicatorPlugin plugin, Runnable onChanged) {
        this.color = color;
        this.onChanged = onChanged;
        this.plugin = plugin;
        this.label = new JLabel(FILL_COLOR_ICON);
        this.label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ColorPicker.this.openColorPicker(ColorPicker.this.label.getLocationOnScreen());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ColorPicker.this.label.setIcon(color.getAlpha() == 0 ? NO_FILL_COLOR_HOVER_ICON : FILL_COLOR_HOVER_ICON);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ColorPicker.this.label.setIcon(color.getAlpha() == 0 ? NO_FILL_COLOR_ICON : FILL_COLOR_ICON);
            }
        });
        this.updateColor();
    }

    private void openColorPicker(Point location) {
        RuneliteColorPicker colorPicker = this.plugin.getColorPickerManager().create(SwingUtilities.windowForComponent(this.label), this.color.getAlpha() == 0 ? ColorUtil.colorWithAlpha((Color)this.color, (int)75) : this.color, "", false);
        colorPicker.setLocation(location);
        colorPicker.setOnColorChange(c -> {
            this.color = c;
            this.updateColor();
            this.onChanged.run();
        });
        colorPicker.setVisible(true);
    }

    private void updateColor() {
        boolean isFullyTransparent;
        boolean bl = isFullyTransparent = this.color.getAlpha() == 0;
        if (isFullyTransparent) {
            this.label.setBorder(null);
        } else {
            Color fullColor = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
            this.label.setBorder(new MatteBorder(0, 0, 3, 0, fullColor));
        }
        this.label.setIcon(isFullyTransparent ? NO_FILL_COLOR_ICON : FILL_COLOR_ICON);
    }

    public Color getColor() {
        return this.color;
    }

    public JComponent getComponent() {
        return this.label;
    }

    static {
        BufferedImage fillImg = ImageUtil.loadImageResource(BossHealthIndicatorPlugin.class, (String)"/color_icon.png");
        BufferedImage fillImgHover = ImageUtil.luminanceOffset((Image)fillImg, (int)-150);
        FILL_COLOR_ICON = new ImageIcon(fillImg);
        FILL_COLOR_HOVER_ICON = new ImageIcon(fillImgHover);
        NO_FILL_COLOR_ICON = new ImageIcon(fillImgHover);
        NO_FILL_COLOR_HOVER_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)fillImgHover, (int)-100));
    }
}

