/*
 * Decompiled with CFR 0.152.
 */
package com.boss.health.indicator.ui;

import com.boss.health.indicator.BossHealthIndicatorPlugin;
import com.boss.health.indicator.SelfRunnable;
import com.boss.health.indicator.model.BossIndicators;
import com.boss.health.indicator.model.Indicator;
import com.boss.health.indicator.ui.IconButton;
import com.boss.health.indicator.ui.Icons;
import com.boss.health.indicator.ui.IndicatorPicker;
import com.boss.health.indicator.ui.TextPicker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class BossIndicatorCreator {
    private TextPicker bossNamePicker;
    private List<IndicatorPicker> indicatorPickers;
    private JPanel indicatorsPanel;
    private Runnable onChanged;
    private BossHealthIndicatorPlugin plugin;
    private SelfRunnable<BossIndicatorCreator> onDelete;
    private JPanel panel;
    private boolean collapsed = false;
    private IconButton collapseButton;
    private IconButton expandButton;

    public BossIndicatorCreator(BossIndicators bossIndicators, Runnable onChanged, BossHealthIndicatorPlugin plugin, SelfRunnable<BossIndicatorCreator> onDelete) {
        this.onChanged = onChanged;
        this.plugin = plugin;
        this.onDelete = onDelete;
        this.bossNamePicker = new TextPicker(bossIndicators.getBossName(), onChanged);
        this.indicatorPickers = new ArrayList<IndicatorPicker>();
        this.indicatorsPanel = new JPanel();
        for (Indicator indicator : bossIndicators.getEntries()) {
            this.indicatorPickers.add(new IndicatorPicker(indicator, onChanged, plugin, self -> {
                this.indicatorPickers.remove(self);
                this.indicatorsPanel.remove(self.getComponent());
                this.indicatorsPanel.revalidate();
                onChanged.run();
            }));
        }
        this.createPanel();
    }

    public BossIndicatorCreator(Runnable onChanged, BossHealthIndicatorPlugin plugin, SelfRunnable<BossIndicatorCreator> onDelete) {
        this.onChanged = onChanged;
        this.plugin = plugin;
        this.onDelete = onDelete;
        this.bossNamePicker = new TextPicker("", onChanged);
        this.indicatorPickers = new ArrayList<IndicatorPicker>();
        this.indicatorsPanel = new JPanel();
        this.createPanel();
    }

    private void createPanel() {
        this.panel = new JPanel(new BorderLayout());
        this.panel.removeAll();
        this.panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 2));
        JPanel topPanel = new JPanel();
        topPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        this.expandButton = new IconButton(Icons.RIGHT_ARROW_ICON, Icons.RIGHT_ARROW_ICON_HOVER, "Expand", () -> this.setCollapsed(false));
        this.collapseButton = new IconButton(Icons.DOWN_ARROW_ICON, Icons.DOWN_ARROW_ICON_HOVER, "Collapse", () -> this.setCollapsed(true));
        this.expandButton.setVisible(this.collapsed);
        this.collapseButton.setVisible(!this.collapsed);
        topPanel.add(this.expandButton);
        topPanel.add(this.collapseButton);
        topPanel.add(Box.createHorizontalStrut(5));
        topPanel.add(this.bossNamePicker.getComponent());
        topPanel.add(Box.createHorizontalStrut(5));
        topPanel.add(new IconButton(Icons.ADD_ICON, Icons.ADD_ICON_HOVER, "Add a new marker", () -> {
            this.setCollapsed(false);
            IndicatorPicker newIndicatorPicker = new IndicatorPicker(this.onChanged, this.plugin, self -> {
                this.indicatorPickers.remove(self);
                JComponent component = self.getComponent();
                component.setAlignmentX(0.0f);
                this.indicatorsPanel.remove(component);
                this.indicatorsPanel.revalidate();
                this.onChanged.run();
            });
            this.indicatorPickers.add(newIndicatorPicker);
            newIndicatorPicker.getComponent().setAlignmentX(0.0f);
            this.indicatorsPanel.add(newIndicatorPicker.getComponent());
            this.indicatorsPanel.revalidate();
            this.onChanged.run();
        }));
        topPanel.add(Box.createHorizontalStrut(5));
        topPanel.add(new IconButton(Icons.REMOVE_ICON, Icons.REMOVE_ICON_HOVER, "Remove boss", () -> this.onDelete.run(this)));
        topPanel.add(Box.createHorizontalStrut(5));
        topPanel.add(new IconButton(Icons.UP_ARROW_ICON, Icons.UP_ARROW_ICON_HOVER, "Move up", () -> this.plugin.moveCreator(this, -1)));
        topPanel.add(Box.createHorizontalStrut(5));
        topPanel.add(new IconButton(Icons.DOWN_ARROW_ICON, Icons.DOWN_ARROW_ICON_HOVER, "Move down", () -> this.plugin.moveCreator(this, 1)));
        this.panel.add((Component)topPanel, "North");
        this.indicatorsPanel.setLayout(new BoxLayout(this.indicatorsPanel, 1));
        for (IndicatorPicker picker : this.indicatorPickers) {
            JComponent component = picker.getComponent();
            component.setAlignmentX(0.0f);
            this.indicatorsPanel.add(picker.getComponent());
        }
        this.panel.add(this.indicatorsPanel);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public BossIndicators getBossIndicators() {
        ArrayList<Indicator> indicators = new ArrayList<Indicator>();
        for (IndicatorPicker indicatorPicker : this.indicatorPickers) {
            Indicator indicator = indicatorPicker.getIndicator();
            indicators.add(indicator);
        }
        return new BossIndicators(this.bossNamePicker.getText(), indicators);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean isCollapsed) {
        this.collapsed = isCollapsed;
        this.expandButton.setVisible(isCollapsed);
        this.collapseButton.setVisible(!isCollapsed);
        this.indicatorsPanel.setVisible(!isCollapsed);
        this.panel.revalidate();
        this.onChanged.run();
    }
}

