/*
 * Decompiled with CFR 0.152.
 */
package com.boss.health.indicator;

import com.boss.health.indicator.BossHealthIndicatorConfig;
import com.boss.health.indicator.BossHealthIndicatorPanel;
import com.boss.health.indicator.model.BossIndicators;
import com.boss.health.indicator.model.Indicator;
import com.boss.health.indicator.ui.BossIndicatorCreator;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.colorpicker.ColorPickerManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Boss Health Indicators", description="Shows indicators for certain health percentages on boss health bars.", tags={"Health Bar"})
public class BossHealthIndicatorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BossHealthIndicatorPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private WorldService worldService;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;
    @Inject
    private ColorPickerManager colorPickerManager;
    @Inject
    private BossHealthIndicatorConfig config;
    @Inject
    private Notifier notifier;
    private static final String CONFIG_GROUP = "bosshealthindicators";
    private static final String CONFIG_KEY = "indicators";
    private NavigationButton navButton;
    private BossHealthIndicatorPanel panel;
    private List<BossIndicators> bossDatabase;
    Map<String, BossIndicators> mapping;
    private Double lastBossHealthPercentage;
    List<Widget> activeBars;
    List<BossIndicators> activeBoss;

    public ColorPickerManager getColorPickerManager() {
        return this.colorPickerManager;
    }

    @Provides
    BossHealthIndicatorConfig provideConfig(ConfigManager configManager) {
        return (BossHealthIndicatorConfig)configManager.getConfig(BossHealthIndicatorConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (this.config.showPanel()) {
            this.clientToolbar.addNavigation(this.navButton);
        } else {
            this.clientToolbar.removeNavigation(this.navButton);
        }
    }

    protected void startUp() throws Exception {
        this.loadFromConfig();
        this.makeDatabaseMap();
        this.activeBars = new ArrayList<Widget>();
        this.activeBoss = null;
        this.lastBossHealthPercentage = null;
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/bosshealthindicator_icon.png");
        this.panel = new BossHealthIndicatorPanel(this);
        this.navButton = NavigationButton.builder().tooltip("Boss Health Indicators").icon(icon).priority(6).panel((PluginPanel)this.panel).build();
        if (this.config.showPanel()) {
            this.clientToolbar.addNavigation(this.navButton);
        }
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        this.activeBoss = null;
        this.clientThread.invoke(() -> this.clearBars());
    }

    private void handleHealthNotification() {
        if (this.activeBoss == null) {
            return;
        }
        Widget healthBarHealthTextWidget = this.client.getWidget(303, 20);
        if (healthBarHealthTextWidget == null) {
            return;
        }
        if (!healthBarHealthTextWidget.isHidden()) {
            String bossHealthText = healthBarHealthTextWidget.getText();
            String[] numbers = bossHealthText.split(" / ");
            try {
                boolean forceCheck;
                int numerator = Integer.parseInt(numbers[0]);
                int denominator = Integer.parseInt(numbers[1].contains("%") ? numbers[1].split(" ")[0] : numbers[1]);
                double percentHealth = (double)numerator / (double)denominator;
                boolean bl = forceCheck = this.lastBossHealthPercentage == null || percentHealth > this.lastBossHealthPercentage;
                if (forceCheck) {
                    this.lastBossHealthPercentage = percentHealth;
                }
                this.activeBoss.forEach(indicatorSet -> indicatorSet.getEntries().forEach(indicator -> {
                    if (!indicator.getNotify()) {
                        return;
                    }
                    if (forceCheck && percentHealth == indicator.getPercentage() || percentHealth <= indicator.getPercentage() && indicator.getPercentage() < this.lastBossHealthPercentage) {
                        this.notifier.notify(String.format("%s's health has reached %s%%!", indicatorSet.getBossName(), new BigDecimal(indicator.getPercentage() * 100.0).stripTrailingZeros().toPlainString()));
                    }
                }));
                this.lastBossHealthPercentage = percentHealth;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private List<BossIndicators> getMatchingIndicators(String bossName) {
        ArrayList<BossIndicators> returnList = new ArrayList<BossIndicators>();
        this.mapping.forEach((name, indicator) -> {
            try {
                Pattern pattern = Pattern.compile(name);
                Matcher matcher = pattern.matcher(bossName);
                if (matcher.matches()) {
                    returnList.add((BossIndicators)indicator);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        });
        return returnList;
    }

    private boolean areBossListsIdentical(List<BossIndicators> a, List<BossIndicators> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            BossIndicators elementA = a.get(i);
            BossIndicators elementB = b.get(i);
            if (a.equals(b)) continue;
            return false;
        }
        return true;
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        Widget healthBarNameTextWidget = this.client.getWidget(303, 9);
        if (healthBarNameTextWidget != null) {
            String bossName = healthBarNameTextWidget.getText();
            List<BossIndicators> newIndicators = this.getMatchingIndicators(bossName);
            if (this.activeBoss == null || !this.areBossListsIdentical(this.activeBoss, newIndicators)) {
                this.clearBars();
                if (this.mapping.containsKey(bossName)) {
                    BossIndicators data = this.mapping.get(bossName);
                    this.activeBoss = newIndicators;
                    this.createBars();
                } else {
                    this.activeBoss = null;
                }
            }
            this.handleHealthNotification();
        }
    }

    void clearBars() {
        for (Widget widget : this.activeBars) {
            widget.setHidden(true);
            widget.revalidate();
        }
        this.activeBars.clear();
    }

    void createBars() {
        Widget parent = this.client.getWidget(303, 12);
        int height = this.client.getWidget(303, 10).getOriginalHeight();
        for (BossIndicators bossIndicators : this.activeBoss) {
            for (Indicator indicator : bossIndicators.getEntries()) {
                Widget bar = this.createBarWidget(parent, indicator.getColor(), indicator.getPercentage(), height);
                this.activeBars.add(bar);
            }
        }
    }

    private Widget createBarWidget(Widget parent, Color color, double percent, int height) {
        Widget bar = parent.createChild(3);
        bar.setOriginalWidth(2);
        bar.setWidthMode(0);
        bar.setOriginalHeight(height);
        bar.setHeightMode(0);
        bar.setOriginalX((int)((double)parent.getWidth() * percent));
        bar.setXPositionMode(0);
        bar.setTextColor(color.getRGB());
        bar.setOpacity(color.getTransparency());
        bar.revalidate();
        return bar;
    }

    private void loadFromConfig() {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, CONFIG_KEY);
        this.bossDatabase = this.stringToBossIndicators(json);
        this.saveToConfig();
    }

    private void saveToConfig() {
        this.configManager.unsetConfiguration(CONFIG_GROUP, CONFIG_KEY);
        String json = this.gson.toJson(this.bossDatabase);
        this.configManager.setConfiguration(CONFIG_GROUP, CONFIG_KEY, json);
    }

    private void makeDatabaseMap() {
        List<BossIndicators> mergedIndicators = this.mergeIndicatorList(this.bossDatabase);
        this.mapping = new HashMap<String, BossIndicators>();
        for (BossIndicators data : mergedIndicators) {
            this.mapping.put(data.getBossName(), data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<BossIndicators> stringToBossIndicators(String string) {
        ArrayList returnList = new ArrayList<BossIndicators>();
        try {
            Type type = new TypeToken<List<BossIndicators>>(){}.getType();
            returnList = (ArrayList)this.gson.fromJson(string, type);
            boolean hasNull = false;
            for (int i = 0; i < returnList.size() && !hasNull; ++i) {
                if (!((BossIndicators)returnList.get(i)).hasAnyNull()) continue;
                hasNull = true;
            }
            if (hasNull) {
                returnList = null;
            }
        }
        catch (Exception e) {
            returnList = null;
        }
        finally {
            if (returnList == null) {
                returnList = new ArrayList();
            }
        }
        return returnList;
    }

    public void updateFromPanel() {
        this.bossDatabase = this.panel.getBossDatabase();
        this.saveToConfig();
        this.makeDatabaseMap();
        this.activeBoss = null;
    }

    private List<BossIndicators> mergeIndicatorList(List<BossIndicators> indicators) {
        HashMap<String, BossIndicators> mergeMap = new HashMap<String, BossIndicators>();
        for (BossIndicators indicator : indicators) {
            String bossName = indicator.getBossName();
            if (!mergeMap.containsKey(bossName)) {
                mergeMap.put(bossName, indicator);
                continue;
            }
            BossIndicators oldIndicator = (BossIndicators)mergeMap.get(bossName);
            ArrayList<Indicator> mergedIndicators = new ArrayList<Indicator>();
            mergedIndicators.addAll(oldIndicator.getEntries());
            mergedIndicators.addAll(indicator.getEntries());
            mergeMap.put(bossName, new BossIndicators(bossName, mergedIndicators));
        }
        return new ArrayList<BossIndicators>(mergeMap.values());
    }

    public List<BossIndicators> getBossDatabase() {
        return this.bossDatabase;
    }

    public void exportToClipboard() {
        String json = this.gson.toJson(this.bossDatabase);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection selection = new StringSelection(json);
        clipboard.setContents(selection, null);
    }

    public void importFromClipboard() {
        String clipboardText = this.getClipboard();
        ArrayList<BossIndicators> originalIndicators = this.stringToBossIndicators(this.configManager.getConfiguration(CONFIG_GROUP, CONFIG_KEY));
        ArrayList<BossIndicators> newIndicators = this.stringToBossIndicators(clipboardText);
        ArrayList<BossIndicators> combined = new ArrayList<BossIndicators>();
        combined.addAll(originalIndicators);
        combined.addAll(newIndicators);
        this.bossDatabase = combined;
        this.makeDatabaseMap();
        this.panel.rebuild();
        this.saveToConfig();
        this.activeBoss = null;
    }

    private String getClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
            try {
                String text = (String)clipboard.getData(DataFlavor.stringFlavor);
                return text;
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public void moveCreator(BossIndicatorCreator creator, int amount) {
        this.panel.moveCreator(creator, amount);
    }
}

