/*
 * Decompiled with CFR 0.152.
 */
package com.boss.health.indicator;

import com.boss.health.indicator.BossHealthIndicatorPlugin;
import com.boss.health.indicator.SelfRunnable;
import com.boss.health.indicator.model.BossIndicators;
import com.boss.health.indicator.ui.BossIndicatorCreator;
import com.boss.health.indicator.ui.IconButton;
import com.boss.health.indicator.ui.Icons;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.PluginPanel;

public class BossHealthIndicatorPanel
extends PluginPanel {
    private BossHealthIndicatorPlugin plugin;
    private List<BossIndicatorCreator> bossIndicatorCreators;
    IconButton expandIcon;
    IconButton collapseIcon;
    JPanel panel;

    BossHealthIndicatorPanel(BossHealthIndicatorPlugin plugin) {
        this.plugin = plugin;
        this.bossIndicatorCreators = new ArrayList<BossIndicatorCreator>();
        this.setBorder(null);
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        this.panel = this.createPanel();
        this.fixCollapseButton();
        this.add(this.panel);
    }

    public JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        Runnable onChanged = () -> {
            this.fixCollapseButton();
            this.plugin.updateFromPanel();
        };
        SelfRunnable<BossIndicatorCreator> onDelete = self -> {
            this.bossIndicatorCreators.remove(self);
            panel.remove(self.getComponent());
            panel.revalidate();
            onChanged.run();
        };
        JPanel topPanel = new JPanel();
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        JLabel titleLabel = new JLabel("Boss Health Indicators");
        IconButton importButton = new IconButton(Icons.IMPORT_ICON, Icons.IMPORT_ICON_HOVER, "Import markers from clipboard", () -> this.plugin.importFromClipboard());
        IconButton exportButton = new IconButton(Icons.EXPORT_ICON, Icons.EXPORT_ICON_HOVER, "Export markers to clipboard", () -> this.plugin.exportToClipboard());
        IconButton addButton = new IconButton(Icons.ADD_ICON, Icons.ADD_ICON_HOVER, "Add a new boss", () -> {
            this.createEmptyBossIndicatorCreator(panel, onChanged, onDelete);
            this.plugin.updateFromPanel();
        });
        this.expandIcon = new IconButton(Icons.RIGHT_ARROW_ICON, Icons.RIGHT_ARROW_ICON_HOVER, "Expand all", () -> this.setAllCollapsed(false));
        this.collapseIcon = new IconButton(Icons.DOWN_ARROW_ICON, Icons.DOWN_ARROW_ICON_HOVER, "Collapse all", () -> this.setAllCollapsed(true));
        topPanel.add(titleLabel);
        topPanel.add(Box.createHorizontalGlue());
        topPanel.add(Box.createHorizontalStrut(5));
        topPanel.add(importButton);
        topPanel.add(Box.createHorizontalStrut(10));
        topPanel.add(exportButton);
        topPanel.add(Box.createHorizontalStrut(10));
        topPanel.add(addButton);
        topPanel.add(Box.createHorizontalStrut(10));
        topPanel.add(this.collapseIcon);
        topPanel.add(this.expandIcon);
        panel.add(topPanel);
        List<BossIndicators> database = this.plugin.getBossDatabase();
        for (BossIndicators bossIndicator : database) {
            BossIndicatorCreator creator = new BossIndicatorCreator(bossIndicator, onChanged, this.plugin, onDelete);
            this.bossIndicatorCreators.add(creator);
            panel.add(creator.getComponent());
        }
        return panel;
    }

    private void createEmptyBossIndicatorCreator(JPanel panel, Runnable onChanged, SelfRunnable<BossIndicatorCreator> onDelete) {
        BossIndicatorCreator creator = new BossIndicatorCreator(onChanged, this.plugin, onDelete);
        this.bossIndicatorCreators.add(creator);
        panel.add(creator.getComponent());
        panel.revalidate();
    }

    public List<BossIndicators> getBossDatabase() {
        ArrayList<BossIndicators> returnList = new ArrayList<BossIndicators>();
        for (BossIndicatorCreator creator : this.bossIndicatorCreators) {
            returnList.add(creator.getBossIndicators());
        }
        return returnList;
    }

    public void rebuild() {
        this.removeAll();
        this.bossIndicatorCreators.clear();
        JPanel panel = this.createPanel();
        this.add(panel);
        this.fixCollapseButton();
        this.revalidate();
    }

    private void fixCollapseButton() {
        boolean anyAreExpanded = false;
        for (BossIndicatorCreator creator : this.bossIndicatorCreators) {
            if (creator.isCollapsed()) continue;
            anyAreExpanded = true;
        }
        this.expandIcon.setVisible(!anyAreExpanded);
        this.collapseIcon.setVisible(anyAreExpanded);
        this.panel.revalidate();
    }

    private void setAllCollapsed(boolean isCollapsed) {
        for (BossIndicatorCreator creator : this.bossIndicatorCreators) {
            creator.setCollapsed(isCollapsed);
        }
    }

    public void moveCreator(BossIndicatorCreator creator, int amount) {
        int creatorIndex = -1;
        for (int i = 0; i < this.bossIndicatorCreators.size() && creatorIndex == -1; ++i) {
            if (this.bossIndicatorCreators.get(i) != creator) continue;
            creatorIndex = i;
        }
        if (creatorIndex == -1) {
            return;
        }
        int goalIndex = creatorIndex + amount;
        goalIndex = Math.max(0, goalIndex);
        goalIndex = Math.min(this.bossIndicatorCreators.size() - 1, goalIndex);
        this.bossIndicatorCreators.remove(creatorIndex);
        this.bossIndicatorCreators.add(goalIndex, creator);
        this.plugin.updateFromPanel();
        this.remove(creator.getComponent());
        this.panel.add((Component)creator.getComponent(), goalIndex + 1);
        this.revalidate();
    }
}

