/*
 * Decompiled with CFR 0.152.
 */
package com.sac.panel;

import com.sac.SalveAmuletCheckerConfig;
import com.sac.SalveAmuletCheckerPlugin;
import com.sac.enums.EntityNames;
import com.sac.panel.ComboBoxIconEntity;
import com.sac.panel.ComboBoxIconListRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalveAmuletCheckerPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(SalveAmuletCheckerPanel.class);
    private JComboBox monsterDropDown;
    private JTextField activeMonsterTextField;
    private final JLabel overallIcon = new JLabel();

    @Inject
    public SalveAmuletCheckerPanel(SalveAmuletCheckerConfig config) {
        super(true);
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new GridBagLayout());
        this.loadMonsterDropDown();
    }

    private void loadMonsterDropDown() {
        JPanel monsterDropDownPanel = new JPanel();
        try {
            this.monsterDropDown = new JComboBox();
            this.monsterDropDown.setFocusable(false);
            EntityNames[] values = EntityNames.values();
            this.monsterDropDown.setMaximumRowCount(values.length);
            this.monsterDropDown.setForeground(Color.WHITE);
            ComboBoxIconListRenderer renderer = new ComboBoxIconListRenderer();
            renderer.setDefaultText("See Monsters");
            this.monsterDropDown.setRenderer(renderer);
            for (EntityNames mobName : values) {
                String imageName = mobName.getEntityName().replaceAll("\\s", "").concat("Small.png");
                BufferedImage dropDownIcon = ImageUtil.loadImageResource(SalveAmuletCheckerPlugin.class, (String)imageName);
                ComboBoxIconEntity<String> entity = new ComboBoxIconEntity<String>(new ImageIcon(dropDownIcon), mobName.getEntityName(), imageName);
                this.monsterDropDown.addItem(entity);
            }
            this.monsterDropDown.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    ComboBoxIconEntity mob = (ComboBoxIconEntity)e.getItem();
                    this.setActiveMonster(mob.getText(), false);
                }
            });
            this.monsterDropDown.setSelectedIndex(-1);
            monsterDropDownPanel.add((Component)this.monsterDropDown, "North");
            this.add(monsterDropDownPanel);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void loadActiveMonsterTextField() {
        JPanel activeMonsterPanel = new JPanel();
        activeMonsterPanel.setLayout(new GridLayout(1, 1));
        this.activeMonsterTextField = new JTextField();
        this.activeMonsterTextField.setEditable(false);
        this.activeMonsterTextField.setText("No Active Monster");
        this.activeMonsterTextField.setFocusable(false);
        this.activeMonsterTextField.setForeground(Color.WHITE);
        activeMonsterPanel.add((Component)this.activeMonsterTextField, "Center");
        this.add(activeMonsterPanel);
    }

    public String getActiveMonster() {
        ComboBoxIconEntity activeMonster = (ComboBoxIconEntity)this.monsterDropDown.getSelectedItem();
        return activeMonster.getText();
    }

    public void loadHeaderIcon(BufferedImage img) {
        this.overallIcon.setIcon(new ImageIcon(img));
    }

    public void setActiveMonster(String activeMonster, boolean isDropDownChanged) {
        if (!isDropDownChanged) {
            return;
        }
        for (int i = 0; i < this.monsterDropDown.getItemCount(); ++i) {
            ComboBoxIconEntity entity = (ComboBoxIconEntity)this.monsterDropDown.getItemAt(i);
            if (entity.getText() != activeMonster) continue;
            this.monsterDropDown.setSelectedIndex(i);
            return;
        }
    }
}

