/*
 * Decompiled with CFR 0.152.
 */
package com.sac.overlays;

import com.google.inject.Inject;
import com.sac.SalveAmuletCheckerConfig;
import com.sac.SalveAmuletCheckerPlugin;
import com.sac.enums.TobState;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class TobLocationOverlay
extends OverlayPanel {
    private final Client client;
    private final SalveAmuletCheckerPlugin plugin;
    private final SalveAmuletCheckerConfig config;

    @Inject
    private TobLocationOverlay(Client client, SalveAmuletCheckerPlugin plugin, SalveAmuletCheckerConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.LOW);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Mystic Salve Amulet Checker Overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        String currentRoom;
        if (this.plugin.tobManager.getTobState() == TobState.InTob && (currentRoom = this.plugin.tobManager.GetRoom()) != null && currentRoom != "") {
            this.panelComponent.getChildren().add(TitleComponent.builder().text(currentRoom).color(Color.white).build());
        }
        return super.render(graphics);
    }
}

