/*
 * Decompiled with CFR 0.152.
 */
package com.sac.overlays;

import com.google.inject.Inject;
import com.sac.SalveAmuletCheckerConfig;
import com.sac.SalveAmuletCheckerPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.HashMap;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Player;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class MysticRoomOverlay
extends OverlayPanel {
    private final Client client;
    private final SalveAmuletCheckerPlugin plugin;
    private final SalveAmuletCheckerConfig config;
    private final ItemManager itemManager;
    private final SpriteManager spriteManager;
    private final PanelComponent panelImages = new PanelComponent();

    @Inject
    private MysticRoomOverlay(Client client, SalveAmuletCheckerPlugin plugin, SalveAmuletCheckerConfig config, ItemManager itemManager, SpriteManager spriteManager) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.LOW);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.itemManager = itemManager;
        this.spriteManager = spriteManager;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Mystic Salve Amulet Checker Overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        Player player = this.client.getLocalPlayer();
        if (player != null && this.plugin.coxManager.isPlayerInCoxRaid() && this.plugin.coxManager.isInMysticRoom(player.getWorldLocation().getPlane(), player.getLocalLocation().getSceneX(), player.getLocalLocation().getSceneY())) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Salve Amulet Checker").color(Color.white).build());
            this.DisplayNames(this.plugin.coxManager.getPlayersInMysticRoom());
        }
        return super.render(graphics);
    }

    private void DisplayNames(HashMap<Player, Boolean> playersInMysticRoom) {
        if (playersInMysticRoom == null) {
            return;
        }
        playersInMysticRoom.forEach((player, isInMysticRoom) -> {
            Color salveAmuletEquipColor = isInMysticRoom != false ? Color.GREEN : Color.red;
            boolean isSalveAmuletEquip = isInMysticRoom;
            if (isInMysticRoom.booleanValue()) {
                isSalveAmuletEquip = this.plugin.isSalveAmuletEquipped((Player)player);
                salveAmuletEquipColor = isSalveAmuletEquip ? Color.green : Color.red;
            }
            this.panelComponent.getChildren().add(LineComponent.builder().left(player.getName()).right(isSalveAmuletEquip ? "Yes" : "No").leftColor(Color.white).rightColor(salveAmuletEquipColor).build());
        });
    }
}

