/*
 * Decompiled with CFR 0.152.
 */
package com.sac.overlays;

import com.google.inject.Inject;
import com.sac.SalveAmuletCheckerConfig;
import com.sac.SalveAmuletCheckerPlugin;
import com.sac.enums.EntityNames;
import com.sac.enums.TobState;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.HashSet;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.Player;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class BloatRoomOverlay
extends OverlayPanel {
    private final Client client;
    private final SalveAmuletCheckerPlugin plugin;
    private final SalveAmuletCheckerConfig config;

    @Inject
    private BloatRoomOverlay(Client client, SalveAmuletCheckerPlugin plugin, SalveAmuletCheckerConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.LOW);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Bloat Salve Amulet Checker Overlay"));
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.tobManager.getTobState() == TobState.InTob && this.plugin.tobManager.GetRoom().equals(EntityNames.BLOAT.getEntityName())) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Salve Amulet Checker").color(Color.white).build());
            this.DisplayNames(this.plugin.tobManager.getRaiderNames());
        }
        return super.render(graphics);
    }

    private void DisplayNames(HashSet<String> playersNames) {
        if (playersNames == null) {
            return;
        }
        playersNames.forEach(playerName -> {
            Player foundPlayer = this.client.getPlayers().stream().filter(player -> player.getName().equals(playerName)).findFirst().orElseGet(() -> null);
            if (foundPlayer != null) {
                boolean isSalveAmuletEquip = this.plugin.isSalveAmuletEquipped(foundPlayer);
                Color salveAmuletEquipColor = isSalveAmuletEquip ? Color.green : Color.red;
                this.panelComponent.getChildren().add(LineComponent.builder().left(foundPlayer.getName()).right(isSalveAmuletEquip ? "Yes" : "No").leftColor(Color.white).rightColor(salveAmuletEquipColor).build());
            }
        });
    }
}

