/*
 * Decompiled with CFR 0.152.
 */
package com.sac.managers;

import com.sac.enums.TobState;
import java.util.HashSet;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.widgets.Widget;
import net.runelite.client.util.Text;

public class TobManager {
    private HashSet<String> tobRaiderNames;
    private TobState tobState;
    private String currentRoom;
    public static int MAX_RAIDERS = 5;
    public static final int THEATRE_RAIDERS_VARC = 330;
    public static final int TOB_BOSS_INTERFACE_ID = 1;
    public static final int TOB_BOSS_INTERFACE_TEXT_ID = 2;
    @Inject
    private Client client;

    public HashSet<String> getRaiderNames() {
        return this.tobRaiderNames;
    }

    public void LoadRaiders() {
        for (int i = 0; i < MAX_RAIDERS; ++i) {
            String playerName = this.client.getVarcStrValue(330 + i);
            if (playerName == null || playerName.isEmpty()) continue;
            this.tobRaiderNames.add(Text.sanitize((String)playerName));
        }
    }

    public String GetRoom() {
        Widget childWidget;
        Widget widget = this.client.getWidget(28, 1);
        if (widget != null && widget.getChild(2) != null && !(childWidget = widget.getChild(2)).getText().equals("")) {
            this.currentRoom = childWidget.getText();
        }
        return this.currentRoom;
    }

    public TobState getTobState() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return TobState.NoParty;
        }
        TobState newRaidState = TobState.fromInteger(this.client.getVarbitValue(6440));
        if (newRaidState == TobState.NoParty || newRaidState == TobState.InParty) {
            this.resetTobState();
        } else {
            this.tobState = newRaidState;
        }
        return this.tobState;
    }

    private void resetTobState() {
        this.tobState = TobState.NoParty;
        this.tobRaiderNames = new HashSet();
    }
}

