/*
 * Decompiled with CFR 0.152.
 */
package com.sac.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InstanceTemplates;
import net.runelite.api.Player;
import net.runelite.api.Tile;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="Salve Amulet Checker", tags={"combat", "overlay", "chambers", "xeric", "raids", "tob", "theatre of blood"})
public class CoxManager {
    @Inject
    private Client client;
    private HashSet<Player> playersInRaid;
    public static final String RAID_START_MESSAGE = "The raid has begun!";
    public static final String RAID_END_MESSAGE = "As the Great Olm collapses, the crystal blocking your exit has been shattered";

    public boolean isPlayerInCoxParty() {
        boolean isInParty = false;
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            isInParty = this.client.getVarbitValue(1427) != -1;
        }
        return isInParty;
    }

    public boolean isPlayerInCoxRaid() {
        boolean isInRaid = false;
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            isInRaid = this.client.getVarbitValue(5432) != 0;
        }
        return isInRaid;
    }

    public boolean isRaidInProgress() {
        boolean isRaidInProgress = false;
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            isRaidInProgress = this.client.getVarbitValue(5425) == 1;
        }
        return isRaidInProgress;
    }

    public boolean isInMysticRoom(Tile currentTile) {
        int chunkData;
        InstanceTemplates template;
        boolean isInMysticTile = false;
        if (this.client.getGameState() == GameState.LOGGED_IN && this.isPlayerInCoxRaid() && (template = InstanceTemplates.findMatch((int)(chunkData = this.client.getInstanceTemplateChunks()[currentTile.getPlane()][currentTile.getSceneLocation().getX() / 8][currentTile.getSceneLocation().getY() / 8]))) == InstanceTemplates.RAIDS_MYSTICS) {
            isInMysticTile = true;
        }
        return isInMysticTile;
    }

    public boolean isInMysticRoom(int currentPlane, int x, int y) {
        int chunkData;
        InstanceTemplates template;
        boolean isInMysticTile = false;
        if (this.client.getGameState() == GameState.LOGGED_IN && this.isPlayerInCoxRaid() && (template = InstanceTemplates.findMatch((int)(chunkData = this.client.getInstanceTemplateChunks()[currentPlane][x / 8][y / 8]))) == InstanceTemplates.RAIDS_MYSTICS) {
            isInMysticTile = true;
        }
        return isInMysticTile;
    }

    public void setUpRaidParty(Tile currentTile) {
        int chunkData;
        InstanceTemplates template;
        HashSet coxRaidParty = new HashSet();
        if (this.client.getGameState() == GameState.LOGGED_IN && this.isPlayerInCoxParty() && currentTile != null && ((template = InstanceTemplates.findMatch((int)(chunkData = this.client.getInstanceTemplateChunks()[currentTile.getPlane()][currentTile.getSceneLocation().getX() / 8][currentTile.getSceneLocation().getY() / 8]))) == InstanceTemplates.RAIDS_LOBBY || template == InstanceTemplates.RAIDS_START)) {
            coxRaidParty.clear();
            coxRaidParty.addAll(this.client.getPlayers());
            this.playersInRaid = coxRaidParty;
        }
    }

    public void setUpRaidParty(int currentPlane, int x, int y) {
        int chunkData;
        InstanceTemplates template;
        HashSet coxRaidParty = new HashSet();
        if (this.client.getGameState() == GameState.LOGGED_IN && this.isPlayerInCoxParty() && ((template = InstanceTemplates.findMatch((int)(chunkData = this.client.getInstanceTemplateChunks()[currentPlane][x / 8][y / 8]))) == InstanceTemplates.RAIDS_LOBBY || template == InstanceTemplates.RAIDS_START)) {
            coxRaidParty.clear();
            coxRaidParty.addAll(this.client.getPlayers());
            this.playersInRaid = coxRaidParty;
        }
    }

    public InstanceTemplates getCurrentRoom(Tile currentTile) {
        if (this.client.getGameState() == GameState.LOGGED_IN && this.isPlayerInCoxRaid() && currentTile != null) {
            int chunkData = this.client.getInstanceTemplateChunks()[currentTile.getPlane()][currentTile.getSceneLocation().getX() / 8][currentTile.getSceneLocation().getY() / 8];
            InstanceTemplates template = InstanceTemplates.findMatch((int)chunkData);
            return template;
        }
        return null;
    }

    public HashMap<Player, Boolean> getPlayersInMysticRoom() {
        HashMap<Player, Boolean> playersInMysticRoom = new HashMap<Player, Boolean>();
        if (this.playersInRaid == null) {
            return playersInMysticRoom;
        }
        for (Player player : this.playersInRaid) {
            boolean isPlayerInMysticRoom = this.isInMysticRoom(player.getWorldLocation().getPlane(), player.getLocalLocation().getSceneX(), player.getLocalLocation().getSceneY());
            if (playersInMysticRoom.containsKey(player.getName())) {
                playersInMysticRoom.replace(player, isPlayerInMysticRoom);
                continue;
            }
            playersInMysticRoom.put(player, isPlayerInMysticRoom);
        }
        return playersInMysticRoom;
    }

    public void removePlayerFromParty(String playerName) {
        this.playersInRaid.removeIf(player -> Objects.equals(player.getName(), playerName));
    }

    public ArrayList<Player> GetRaidParty() {
        return new ArrayList<Player>(this.playersInRaid);
    }

    public void clearRaiders() {
        this.playersInRaid.clear();
    }

    public HashSet<Player> getPlayersInRaid() {
        return this.playersInRaid;
    }
}

