/*
 * Decompiled with CFR 0.152.
 */
package com.sac;

import com.google.inject.Provides;
import com.sac.SalveAmuletCheckerConfig;
import com.sac.enums.EntityNames;
import com.sac.enums.TobState;
import com.sac.infoboxs.SalveAmuletCheckerInfoBox;
import com.sac.managers.CoxManager;
import com.sac.managers.TobManager;
import com.sac.overlays.BloatRoomOverlay;
import com.sac.overlays.CoxLocationOverlay;
import com.sac.overlays.MysticRoomOverlay;
import com.sac.overlays.TobLocationOverlay;
import com.sac.panel.SalveAmuletCheckerPanel;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.kit.KitType;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="SalveAmuletChecker")
public class SalveAmuletCheckerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SalveAmuletCheckerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private SalveAmuletCheckerConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    public TobManager tobManager;
    @Inject
    public CoxManager coxManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MysticRoomOverlay mysticRoomOverlay;
    @Inject
    private CoxLocationOverlay coxLocationOverlay;
    @Inject
    private BloatRoomOverlay bloatRoomOverlay;
    @Inject
    private TobLocationOverlay tobLocationOverlay;
    private TobState currentTobState;
    private SalveAmuletCheckerPanel panel;
    private NavigationButton navButton;
    private SalveAmuletCheckerInfoBox coxSalveAmuletCheckerInfoBox;
    private SalveAmuletCheckerInfoBox raidStateInfoBox;
    private SalveAmuletCheckerInfoBox locationSalveAmuletInfoBox;

    protected void startUp() throws Exception {
        if (this.config.isSidePanelVisible()) {
            this.addNavBar();
        }
        log.info("Salve Amulet Checker started!");
        this.overlayManager.add((Overlay)this.mysticRoomOverlay);
        this.overlayManager.add((Overlay)this.coxLocationOverlay);
        this.overlayManager.add((Overlay)this.bloatRoomOverlay);
        this.overlayManager.add((Overlay)this.tobLocationOverlay);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        this.panel = null;
        this.navButton = null;
        log.info("Salve Amulet Checker stopped!");
        this.overlayManager.remove((Overlay)this.mysticRoomOverlay);
        this.overlayManager.remove((Overlay)this.coxLocationOverlay);
        this.overlayManager.remove((Overlay)this.bloatRoomOverlay);
        this.overlayManager.remove((Overlay)this.tobLocationOverlay);
    }

    @Provides
    SalveAmuletCheckerConfig provideConfig(ConfigManager configManager) {
        return (SalveAmuletCheckerConfig)configManager.getConfig(SalveAmuletCheckerConfig.class);
    }

    public void addNavBar() {
        this.panel = (SalveAmuletCheckerPanel)((Object)this.injector.getInstance(SalveAmuletCheckerPanel.class));
        BufferedImage ICON = ImageUtil.loadImageResource(SalveAmuletCheckerPlugin.class, (String)"salveAmuletEi.png");
        this.navButton = NavigationButton.builder().tooltip("Salve Amulet Checker").icon(ICON).priority(10).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    public void removeNavBar() {
        if (this.navButton != null && this.panel != null) {
            this.clientToolbar.removeNavigation(this.navButton);
            this.navButton = null;
            this.panel = null;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        String configName = event.getKey();
        if (configName.equals("isSidePanelVisible")) {
            boolean isSidePanelVisible = Boolean.parseBoolean(event.getNewValue());
            if (isSidePanelVisible && this.navButton == null && this.panel == null) {
                this.addNavBar();
            } else {
                this.removeNavBar();
            }
        }
    }

    @Subscribe(priority=-1.0f)
    public void onGameTick(GameTick event) {
        this.computeActiveCheck();
    }

    private void computeActiveCheck() {
        if (this.config.isEnabledInTob()) {
            this.currentTobState = this.tobManager.getTobState();
            if (this.currentTobState == TobState.InTob) {
                if (this.config.isSidePanelVisible()) {
                    this.panel.setActiveMonster(EntityNames.BLOAT.getEntityName(), true);
                }
                this.tobManager.LoadRaiders();
                if (this.tobManager.GetRoom().equals(EntityNames.BLOAT.getEntityName())) {
                    for (Player player2 : this.client.getPlayers()) {
                        if (!this.tobManager.getRaiderNames().contains(player2.getName()) || this.isSalveAmuletEquipped(player2) || !this.config.isToxic()) continue;
                        this.whenSalveAmuletNotEquipped(player2);
                    }
                }
            }
        }
        if (this.config.isEnabledInCox() && this.coxManager.isPlayerInCoxRaid()) {
            if (this.config.isSidePanelVisible()) {
                this.panel.setActiveMonster(EntityNames.MYSTIC.getEntityName(), true);
            }
            HashMap<Player, Boolean> playersMap = this.coxManager.getPlayersInMysticRoom();
            playersMap.forEach((player, isInMysticRoom) -> {
                if (isInMysticRoom.booleanValue() && !this.isSalveAmuletEquipped((Player)player) && this.config.isToxic()) {
                    this.whenSalveAmuletNotEquipped((Player)player);
                }
            });
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String chatMessage = Text.removeTags((String)event.getMessage());
        if (this.config.isEnabledInCox()) {
            this.coxChatMessageAction(chatMessage);
        }
    }

    private void coxChatMessageAction(String chatMessage) {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        if (chatMessage.startsWith("The raid has begun!")) {
            this.coxManager.setUpRaidParty(player.getWorldLocation().getPlane(), player.getLocalLocation().getSceneX(), player.getLocalLocation().getSceneY());
        } else if (chatMessage.startsWith("As the Great Olm collapses, the crystal blocking your exit has been shattered")) {
            this.coxManager.clearRaiders();
        }
    }

    public boolean isSalveAmuletEquipped(Player player) {
        int itemId = player.getPlayerComposition().getEquipmentId(KitType.AMULET);
        return this.isSalveAmulet(itemId);
    }

    private void whenSalveAmuletNotEquipped(Player offendingPlayer) {
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, offendingPlayer.getName(), String.format("%s Is not wearing their Salve Amulet!", offendingPlayer.getName()), null);
    }

    public boolean isSalveAmulet(int itemId) {
        boolean isSalveAmulet = false;
        if (itemId == 4081 || itemId == 10588 || itemId == 12018) {
            isSalveAmulet = true;
        }
        return isSalveAmulet;
    }

    private SalveAmuletCheckerInfoBox addInfoBox(BufferedImage image, String text, String toolTip) {
        SalveAmuletCheckerInfoBox infoBox = new SalveAmuletCheckerInfoBox(image, this);
        infoBox.setInfoBoxText(text);
        infoBox.setTooltip(toolTip);
        return infoBox;
    }

    private void removeInfoBox(InfoBox infoBox) {
        this.infoBoxManager.removeInfoBox(infoBox);
        infoBox = null;
    }

    private SalveAmuletCheckerInfoBox createInfoBox(BufferedImage image, String text, String toolTip, Color textBoxColor) {
        SalveAmuletCheckerInfoBox salveAmuletInfoBox = new SalveAmuletCheckerInfoBox(image, this);
        salveAmuletInfoBox.setInfoBoxText(text);
        salveAmuletInfoBox.setTooltip(toolTip);
        salveAmuletInfoBox.setInfoBoxTextColor(textBoxColor);
        return salveAmuletInfoBox;
    }

    private void addCoxSalveAmuletCheckerInfoBox(String text, String toolTip, Color color) {
        this.removeInfoBox(this.locationSalveAmuletInfoBox);
        this.locationSalveAmuletInfoBox = this.addInfoBox((BufferedImage)this.itemManager.getImage(12018), text, toolTip);
        this.infoBoxManager.addInfoBox((InfoBox)this.locationSalveAmuletInfoBox);
    }

    private void addPlayerSalveAmuletCheckerInfoBox(String text, String toolTip, Color color) {
        this.removeInfoBox(this.coxSalveAmuletCheckerInfoBox);
        this.coxSalveAmuletCheckerInfoBox = this.addInfoBox((BufferedImage)this.itemManager.getImage(7158), text, toolTip);
        this.infoBoxManager.addInfoBox((InfoBox)this.coxSalveAmuletCheckerInfoBox);
    }

    private void addRaidStateInfoBox(String text, String toolTip, Color color) {
        this.removeInfoBox(this.raidStateInfoBox);
        this.raidStateInfoBox = this.addInfoBox((BufferedImage)this.itemManager.getImage(23794), text, toolTip);
        this.infoBoxManager.addInfoBox((InfoBox)this.raidStateInfoBox);
    }
}

