/*
 * Decompiled with CFR 0.152.
 */
package com.xpnotify;

import com.google.inject.Provides;
import com.xpnotify.XpNotifyConfig;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.events.StatChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="XP Drop Notify")
public class XpNotifyPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(XpNotifyPlugin.class);
    private final Set<String> filteredSkills = new HashSet<String>();
    private static final int[] previous_exp = new int[Skill.values().length - 1];
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private XpNotifyConfig config;

    protected void startUp() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invokeLater(() -> {
                int[] xps = this.client.getSkillExperiences();
                System.arraycopy(xps, 0, previous_exp, 0, previous_exp.length);
            });
        } else {
            Arrays.fill(previous_exp, 0);
        }
        this.loadFilteredSkills();
    }

    @Subscribe
    protected void onConfigChanged(ConfigChanged configChanged) {
        if ("XpNotify".equals(configChanged.getGroup())) {
            if ("skillsToFilter".equals(configChanged.getKey())) {
                this.loadFilteredSkills();
            } else if ("soundId".equals(configChanged.getKey())) {
                this.clientThread.invoke(() -> this.client.playSoundEffect(this.config.soundId(), this.config.volume()));
            }
        }
    }

    private void loadFilteredSkills() {
        this.filteredSkills.clear();
        this.filteredSkills.addAll(Text.fromCSV((String)this.config.skillsToFilter()).stream().map(String::toLowerCase).collect(Collectors.toList()));
        if (this.filteredSkills.contains("runecrafting")) {
            this.filteredSkills.add("runecraft");
        }
    }

    @Subscribe
    protected void onStatChanged(StatChanged event) {
        int currentXp = event.getXp();
        int previousXp = previous_exp[event.getSkill().ordinal()];
        if (previousXp > 0 && currentXp - previousXp > 0 && !this.filteredSkills.contains(event.getSkill().getName().toLowerCase())) {
            this.client.playSoundEffect(this.config.soundId(), this.config.volume());
        }
        XpNotifyPlugin.previous_exp[event.getSkill().ordinal()] = event.getXp();
    }

    @Provides
    XpNotifyConfig provideConfig(ConfigManager configManager) {
        return (XpNotifyConfig)configManager.getConfig(XpNotifyConfig.class);
    }
}

