/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.masterscrollbook;

import com.google.inject.Inject;
import com.google.inject.Provides;
import io.hydrox.masterscrollbook.MasterScrollBookConfig;
import io.hydrox.masterscrollbook.MasterScrollBookOverlay;
import io.hydrox.masterscrollbook.Scroll;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.RuneScapeProfileChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Master Scroll Book", description="See the contents of your Master Scroll Book without opening it.", tags={"scroll", "treasure", "book", "teleport", "overlay", "indicator"})
public class MasterScrollBookPlugin
extends Plugin {
    private static final int VARBIT_SELECTED_DEFAULT_SCROLL = 5685;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private MasterScrollBookConfig config;
    @Inject
    private MasterScrollBookOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    private final Map<Scroll, Integer> counts = new HashMap<Scroll, Integer>();
    private Scroll selectedDefault = null;

    @Provides
    MasterScrollBookConfig provideConfig(ConfigManager configManager) {
        return (MasterScrollBookConfig)configManager.getConfig(MasterScrollBookConfig.class);
    }

    public void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invoke(this::update);
        }
    }

    public void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged e) {
        this.update();
    }

    @Subscribe
    public void onRuneScapeProfileChanged(RuneScapeProfileChanged e) {
        this.counts.clear();
    }

    private void update() {
        int sel;
        Scroll used = null;
        for (Scroll s : Scroll.values()) {
            int newValue = this.client.getVarbitValue(s.getVarbit());
            Integer oldValue = this.counts.put(s, newValue);
            if (oldValue == null || oldValue != newValue + 1) continue;
            used = s;
        }
        if (used != null && this.config.showTeleportMessages()) {
            int value = this.counts.get((Object)used);
            ChatMessageBuilder sb = new ChatMessageBuilder();
            sb.append(ChatColorType.HIGHLIGHT);
            sb.append("You have ");
            sb.append(Integer.toString(value));
            sb.append(" ");
            sb.append(used.getName());
            sb.append(" teleport scroll");
            if (value != 1) {
                sb.append("s");
            }
            sb.append(" left.");
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(sb.build()).build());
        }
        this.selectedDefault = (sel = this.client.getVarbitValue(5685)) == 0 ? null : Scroll.get(sel - 1);
    }

    public Map<Scroll, Integer> getCounts() {
        return this.counts;
    }

    public Scroll getSelectedDefault() {
        return this.selectedDefault;
    }
}

