/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.masterscrollbook;

import com.google.inject.Inject;
import io.hydrox.masterscrollbook.MasterScrollBookPlugin;
import io.hydrox.masterscrollbook.Scroll;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Map;
import net.runelite.api.Client;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;

public class MasterScrollBookOverlay
extends WidgetItemOverlay {
    private final Client client;
    private final MasterScrollBookPlugin plugin;
    private final TooltipManager tooltipManager;

    @Inject
    MasterScrollBookOverlay(Client client, MasterScrollBookPlugin plugin, TooltipManager tooltipManager) {
        this.client = client;
        this.plugin = plugin;
        this.tooltipManager = tooltipManager;
        this.showOnInventory();
        this.showOnBank();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        if (itemId != 21389) {
            return;
        }
        Map<Scroll, Integer> counts = this.plugin.getCounts();
        StringBuilder tooltipBuilder = new StringBuilder();
        Scroll sel = this.plugin.getSelectedDefault();
        if (sel != null) {
            Rectangle bounds = widgetItem.getCanvasBounds();
            int drawX = bounds.x;
            int drawY = bounds.y + bounds.height;
            String text = "" + counts.get((Object)sel);
            graphics.setFont(FontManager.getRunescapeSmallFont());
            graphics.setColor(Color.BLACK);
            graphics.drawString(text, drawX + 1, drawY + 1);
            graphics.setColor(Color.WHITE);
            graphics.drawString(text, drawX, drawY);
            tooltipBuilder.append(text).append(" ").append(ColorUtil.wrapWithColorTag((String)sel.getName(), (Color)Color.GREEN)).append("</br>");
        }
        if (!widgetItem.getCanvasBounds().contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY())) {
            return;
        }
        for (Scroll s : Scroll.values()) {
            if (s == sel) continue;
            tooltipBuilder.append(counts.getOrDefault((Object)s, 0)).append(" ").append(ColorUtil.wrapWithColorTag((String)s.getName(), (Color)Color.YELLOW)).append("</br>");
        }
        this.tooltipManager.add(new Tooltip(tooltipBuilder.toString()));
    }
}

