/*
 * Decompiled with CFR 0.152.
 */
package com.eventsapi.notifications;

import com.eventsapi.interfaces.Sendable;
import com.eventsapi.notifications.EventWrapper;
import java.util.Map;

public class LevelChangeNotification
implements Sendable {
    private static final String API_ENDPOINT = "level_change/";
    private int totalLevel;
    private String updatedSkillName;
    private Integer updatedSkillLevel;
    private Map<String, Integer> levels;

    public LevelChangeNotification(String name, Integer level, Map<String, Integer> levelMap) {
        this.setUpdatedSkillName(name);
        this.setUpdatedSkillLevel(level);
        this.setLevels(levelMap);
        int totalLevel = 0;
        for (Integer skillLevel : levelMap.values()) {
            totalLevel += skillLevel.intValue();
        }
        this.setTotalLevel(totalLevel);
    }

    @Override
    public EventWrapper getEventWrapper() {
        return new EventWrapper(this);
    }

    @Override
    public String getApiEndpoint() {
        return API_ENDPOINT;
    }

    public int getTotalLevel() {
        return this.totalLevel;
    }

    public void setTotalLevel(int totalLevel) {
        this.totalLevel = totalLevel;
    }

    public String getUpdatedSkillName() {
        return this.updatedSkillName;
    }

    public void setUpdatedSkillName(String updatedSkillName) {
        this.updatedSkillName = updatedSkillName;
    }

    public Integer getUpdatedSkillLevel() {
        return this.updatedSkillLevel;
    }

    public void setUpdatedSkillLevel(Integer updatedSkillLevel) {
        this.updatedSkillLevel = updatedSkillLevel;
    }

    public Map<String, Integer> getLevels() {
        return this.levels;
    }

    public void setLevels(Map<String, Integer> levels) {
        this.levels = levels;
    }
}

