/*
 * Decompiled with CFR 0.152.
 */
package com.eventsapi;

import com.eventsapi.MessageChannel;
import com.eventsapi.enums.MESSAGE_EVENT;
import com.eventsapi.interfaces.ApiConnectable;
import com.eventsapi.interfaces.Sendable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandler {
    private Map<MESSAGE_EVENT, MessageChannel> eventChannels = new HashMap<MESSAGE_EVENT, MessageChannel>();
    private ApiConnectable apiConnection;
    private static final double GAME_TICKS_PER_SECOND = 0.6;
    private static final Logger logger = LoggerFactory.getLogger(MessageHandler.class);

    public MessageHandler(ApiConnectable apiConnection) {
        this.apiConnection = apiConnection;
        this.eventChannels.put(MESSAGE_EVENT.BANK, new MessageChannel(this.secondsToGameTicks(10)));
        this.eventChannels.put(MESSAGE_EVENT.INVO, new MessageChannel(this.secondsToGameTicks(2)));
        this.eventChannels.put(MESSAGE_EVENT.EQUIPMENT, new MessageChannel(this.secondsToGameTicks(2)));
    }

    private int secondsToGameTicks(int seconds) {
        return (int)((double)seconds / 0.6);
    }

    private List<Sendable> getMessagesFromQueues() {
        ArrayList<Sendable> messages = new ArrayList<Sendable>();
        for (MessageChannel channel : this.eventChannels.values()) {
            Sendable message = channel.getMessageToSend();
            if (message == null) continue;
            messages.add(message);
        }
        return messages;
    }

    public void sendEventNow(MESSAGE_EVENT eventType, Sendable message) {
        logger.debug("Sending event now: " + eventType.toString());
        this.apiConnection.send(message);
    }

    public void processGameTicks() {
        for (MessageChannel channel : this.eventChannels.values()) {
            channel.processGameTick();
        }
        List<Sendable> messagesToSend = this.getMessagesFromQueues();
        if (messagesToSend.size() > 0) {
            logger.debug("Sending message list to ApiConnectable to be sent: " + messagesToSend.size() + " messages");
            this.apiConnection.send(messagesToSend);
        }
    }

    public void updateLatestEvent(MESSAGE_EVENT eventType, Sendable event) {
        logger.debug("Attempting to insert event of type: " + eventType.toString());
        try {
            this.eventChannels.get((Object)eventType).updateLatest(event);
            logger.debug("Queued " + eventType.toString() + " message to be sent");
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }
}

