/*
 * Decompiled with CFR 0.152.
 */
package com.eventsapi;

import com.eventsapi.interfaces.Sendable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageChannel {
    private boolean canSend = false;
    private boolean hasSent = false;
    private Sendable latestMessage;
    private int gameTicksBetweenFrequentActions = 0;
    private int gameTicksSinceSending = 0;
    private static final Logger logger = LoggerFactory.getLogger(MessageChannel.class);

    public MessageChannel(int gameTicksBetweenFrequentActions) {
        this.gameTicksBetweenFrequentActions = gameTicksBetweenFrequentActions;
        this.canSend = true;
    }

    public void processGameTick() {
        if (this.gameTicksSinceSending < this.gameTicksBetweenFrequentActions) {
            ++this.gameTicksSinceSending;
        }
        if (!this.canSend && this.gameTicksSinceSending >= this.gameTicksBetweenFrequentActions) {
            this.canSend = true;
            this.gameTicksSinceSending = 0;
        }
    }

    public void updateLatest(Sendable message) {
        this.latestMessage = message;
        this.hasSent = false;
    }

    public Sendable getMessageToSend() {
        if (!this.hasSent && this.canSend) {
            this.hasSent = true;
            this.gameTicksSinceSending = 0;
            this.canSend = false;
            return this.latestMessage;
        }
        return null;
    }
}

