/*
 * Decompiled with CFR 0.152.
 */
package com.eventsapi;

import com.eventsapi.ApiManager;
import com.eventsapi.EventsAPIConfig;
import com.eventsapi.MessageHandler;
import com.eventsapi.enums.LOGIN_STATE;
import com.eventsapi.enums.MESSAGE_EVENT;
import com.eventsapi.notifications.BankNotification;
import com.eventsapi.notifications.EquipSlotsNotification;
import com.eventsapi.notifications.InventorySlotsNotification;
import com.eventsapi.notifications.LevelChangeNotification;
import com.eventsapi.notifications.LoginNotification;
import com.eventsapi.notifications.NpcKillNotification;
import com.eventsapi.notifications.PlayerStatusNotification;
import com.eventsapi.notifications.QuestChangeNotification;
import com.eventsapi.pojos.BankItem;
import com.eventsapi.pojos.QuestInfo;
import com.eventsapi.utils.CommonUtility;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.api.Quest;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.StatChanged;
import net.runelite.api.vars.AccountType;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="EventsAPI")
public class EventsAPIPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EventsAPIPlugin.class);
    @Inject
    private Client client;
    @Inject
    private EventsAPIConfig config;
    @Inject
    private ItemManager itemManager;
    private int tickIterator = 0;
    private boolean hasLoggedIn = false;
    private boolean hasTicked;
    private int[] lastSkillLevels;
    private QuestState[] lastQuestStates;
    private Quest[] quests;
    private boolean lastBankOpenStatus;
    private Item[] lastInventoryState;
    private ItemContainer lastBankContainer;
    private MessageHandler messageHandler;
    private static final Logger logger = LoggerFactory.getLogger(EventsAPIPlugin.class);

    protected void startUp() throws Exception {
        log.info("EventsAPIPlugin Started!");
        ApiManager apiManager = new ApiManager(this.config, this.client);
        this.messageHandler = new MessageHandler(apiManager);
        this.initializeSessionVariables();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        ++this.tickIterator;
        if (!this.hasTicked) {
            logger.debug("First game tick detected, handle initial events");
            this.hasTicked = true;
            this.populateCurrentQuests();
            this.sendInitialLoginEvents();
        }
        this.detectQuestEvents();
        this.detectBankWindowClosing();
        if (this.tickIterator == this.config.tickDelay()) {
            this.createAndSendPlayerStatusNotification();
            this.tickIterator = 0;
        }
        this.messageHandler.processGameTicks();
    }

    private void initializeSessionVariables() {
        this.lastSkillLevels = new int[Skill.values().length - 1];
        this.hasTicked = false;
        this.lastQuestStates = new QuestState[Quest.values().length];
        this.lastBankOpenStatus = false;
        this.quests = Quest.values();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged state) {
        if (state.getGameState() == GameState.LOGIN_SCREEN) {
            if (this.hasLoggedIn) {
                LoginNotification loggedOut = new LoginNotification(LOGIN_STATE.LOGGED_OUT);
                this.messageHandler.sendEventNow(MESSAGE_EVENT.LOGIN, loggedOut);
                this.hasLoggedIn = false;
            }
            logger.debug("Player is on login screen, setting up session variables");
            this.initializeSessionVariables();
        }
        if (state.getGameState() == GameState.LOGGED_IN) {
            this.hasLoggedIn = true;
            LoginNotification loggedIn = new LoginNotification(LOGIN_STATE.LOGGED_IN);
            this.messageHandler.sendEventNow(MESSAGE_EVENT.LOGIN, loggedIn);
        }
    }

    private void sendInitialLoginEvents() {
        logger.debug("Sending initial level and quest notifications");
        this.createAndSendLevelNotification(null, null);
        this.createAndSendQuestNotification(null, null);
    }

    private void populateCurrentQuests() {
        logger.debug("Populating quest states with latest player states");
        for (int i = 0; i < this.quests.length; ++i) {
            QuestState currentQuestState;
            this.lastQuestStates[i] = currentQuestState = this.quests[i].getState(this.client);
        }
    }

    private void detectQuestEvents() {
        boolean questChangeFound = false;
        for (int i = 0; i < this.quests.length; ++i) {
            QuestState currentQuestState;
            if (this.lastQuestStates[i] == this.quests[i].getState(this.client)) continue;
            String questName = this.quests[i].getName();
            this.lastQuestStates[i] = currentQuestState = this.quests[i].getState(this.client);
            if (questChangeFound) continue;
            logger.debug("Detected new quest state: " + questName + " is now: " + currentQuestState.toString());
            this.createAndSendQuestNotification(questName, currentQuestState);
            questChangeFound = true;
        }
    }

    private void detectBankWindowClosing() {
        Widget con = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        if (con != null) {
            this.lastBankOpenStatus = true;
            this.lastBankContainer = this.client.getItemContainer(InventoryID.BANK);
        } else if (this.lastBankOpenStatus) {
            this.lastBankOpenStatus = false;
            logger.debug("Detected closing of bank window. Preparing bank notification");
            this.createAndQueueBankNotification();
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() == this.client.getItemContainer(InventoryID.EQUIPMENT)) {
            logger.debug("Detected ItemContainer change for EQUIPMENT, preparing to queue event");
            this.createAndQueueEquipmentNotification(event.getItemContainer().getItems());
        }
        if (event.getItemContainer() == this.client.getItemContainer(InventoryID.INVENTORY)) {
            if (this.lastInventoryState == null) {
                logger.debug("First time seeing inventory event, prepare to create first Inventory Notification");
                this.lastInventoryState = event.getItemContainer().getItems();
                this.createAndQueueInvoNotification(this.lastInventoryState);
                return;
            }
            ItemContainer currentContainer = event.getItemContainer();
            boolean containersEqual = CommonUtility.areItemContainerEqual(this.lastInventoryState, currentContainer.getItems());
            if (!containersEqual) {
                logger.debug("Detected changed inventory, prepare to create latest Inventory Notification");
                this.createAndQueueInvoNotification(event.getItemContainer().getItems());
                this.lastInventoryState = currentContainer.getItems();
            }
        }
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        logger.debug("Detected npcLootReceived from npc with id: " + npcLootReceived.getNpc().getId() + " , preparing to send event");
        this.createAndSendLootNotification(npcLootReceived);
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        boolean didLevel;
        int currentLevel;
        Skill updatedSkill = statChanged.getSkill();
        int skillIdx = updatedSkill.ordinal();
        int lastLevel = this.lastSkillLevels[skillIdx];
        this.lastSkillLevels[skillIdx] = currentLevel = this.client.getRealSkillLevel(updatedSkill);
        boolean bl = didLevel = lastLevel != 0 && currentLevel > lastLevel;
        if (didLevel && this.hasTicked) {
            logger.debug("Level up detected, preparing to queue event: " + updatedSkill.getName() + " lvl: " + currentLevel);
            this.createAndSendLevelNotification(updatedSkill.getName(), currentLevel);
        }
    }

    private void createAndSendLootNotification(NpcLootReceived lootReceived) {
        int geTotalPrice = 0;
        int npcId = lootReceived.getNpc().getId();
        ArrayList<Item> items = new ArrayList<Item>();
        for (ItemStack item : lootReceived.getItems()) {
            items.add(new Item(item.getId(), item.getQuantity()));
            geTotalPrice += item.getQuantity() * this.itemManager.getItemComposition(item.getId()).getPrice();
        }
        NpcKillNotification notification = new NpcKillNotification(npcId, items, geTotalPrice);
        this.messageHandler.sendEventNow(MESSAGE_EVENT.LOOT, notification);
    }

    private void createAndQueueBankNotification() {
        if (this.lastBankContainer == null) {
            return;
        }
        Item[] bankItems = this.lastBankContainer.getItems();
        ArrayList<BankItem> items = new ArrayList<BankItem>();
        int totalPrice = 0;
        for (Item bankItem : bankItems) {
            boolean isPlaceholder;
            int id = bankItem.getId();
            if (id <= -1) continue;
            int quantity = bankItem.getQuantity();
            ItemComposition itemComp = this.itemManager.getItemComposition(id);
            boolean bl = isPlaceholder = itemComp.getPlaceholderTemplateId() == 14401;
            if (isPlaceholder) {
                quantity = 0;
            }
            int gePrice = quantity * itemComp.getPrice();
            totalPrice += gePrice;
            BankItem bankItemToAdd = new BankItem(id, quantity);
            items.add(bankItemToAdd);
        }
        logger.debug("Preparing to send bank notification to message handler");
        BankNotification bankNotification = new BankNotification(items, totalPrice);
        this.messageHandler.updateLatestEvent(MESSAGE_EVENT.BANK, bankNotification);
    }

    private void createAndSendLevelNotification(String name, Integer level) {
        logger.debug("Preparing to send level notification to message handler");
        Map<String, Integer> levelMap = this.getLevelMap();
        LevelChangeNotification levelEvent = new LevelChangeNotification(name, level, levelMap);
        this.messageHandler.sendEventNow(MESSAGE_EVENT.LEVEL, levelEvent);
    }

    private void createAndSendQuestNotification(String quest, QuestState state) {
        logger.debug("Preparing to send quest status to message handler");
        List<QuestInfo> quests = this.getQuestInfoList();
        QuestChangeNotification questEvent = new QuestChangeNotification(quest, state, quests, this.client.getVar(101));
        this.messageHandler.sendEventNow(MESSAGE_EVENT.QUEST, questEvent);
    }

    private void createAndQueueInvoNotification(Item[] invoItems) {
        logger.debug("Preparing to send inventory notification to message handler");
        ArrayList<Item> inventoryItems = new ArrayList<Item>();
        int MAX_INVO_SLOTS = 28;
        int geTotalPrice = 0;
        for (int i = 0; i < 28; ++i) {
            if (i > invoItems.length - 1) {
                inventoryItems.add(new Item(0, 0));
                continue;
            }
            if (invoItems[i].getId() > 0 && invoItems[i].getQuantity() > 0) {
                geTotalPrice += invoItems[i].getQuantity() * this.itemManager.getItemComposition(invoItems[i].getId()).getPrice();
                inventoryItems.add(invoItems[i]);
                continue;
            }
            inventoryItems.add(new Item(0, 0));
        }
        InventorySlotsNotification invoEvent = new InventorySlotsNotification(inventoryItems, geTotalPrice);
        this.messageHandler.updateLatestEvent(MESSAGE_EVENT.INVO, invoEvent);
    }

    private void createAndQueueEquipmentNotification(Item[] equippedItems) {
        logger.debug("Preparing to send equipment notification to message handler");
        EquipmentInventorySlot[] slots = EquipmentInventorySlot.values();
        HashMap<EquipmentInventorySlot, Item> equipped = new HashMap<EquipmentInventorySlot, Item>();
        for (int i = 0; i < slots.length; ++i) {
            Item item;
            if (slots[i].getSlotIdx() >= equippedItems.length || (item = equippedItems[slots[i].getSlotIdx()]).getId() <= 0 || item.getQuantity() <= 0) continue;
            equipped.put(slots[i], item);
        }
        EquipSlotsNotification equipEvent = new EquipSlotsNotification(equipped);
        this.messageHandler.updateLatestEvent(MESSAGE_EVENT.EQUIPMENT, equipEvent);
    }

    private Map<String, Integer> getLevelMap() {
        Skill[] skills;
        HashMap<String, Integer> levelMap = new HashMap<String, Integer>();
        for (Skill iskill : skills = Skill.values()) {
            levelMap.put(iskill.getName(), this.client.getRealSkillLevel(iskill));
        }
        return levelMap;
    }

    private List<QuestInfo> getQuestInfoList() {
        ArrayList<QuestInfo> questInfo = new ArrayList<QuestInfo>();
        for (Quest quest : this.quests) {
            questInfo.add(new QuestInfo(quest.getName(), quest.getId(), quest.getState(this.client)));
        }
        return questInfo;
    }

    private void createAndSendPlayerStatusNotification() {
        Player temp_player = this.client.getLocalPlayer();
        String userName = temp_player.getName();
        AccountType accountType = this.client.getAccountType();
        int combatLevel = temp_player.getCombatLevel();
        int currentWorld = this.client.getWorld();
        WorldPoint currentWorldPoint = temp_player.getWorldLocation();
        int currentHealth = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
        int maxHealth = this.client.getRealSkillLevel(Skill.HITPOINTS);
        int currentPrayer = this.client.getBoostedSkillLevel(Skill.PRAYER);
        int maxPrayer = this.client.getRealSkillLevel(Skill.PRAYER);
        int currentRun = this.client.getEnergy();
        int currentWeight = this.client.getWeight();
        PlayerStatusNotification notification = new PlayerStatusNotification(userName, accountType, combatLevel, currentWorld, currentWorldPoint, maxHealth, currentHealth, maxPrayer, currentPrayer, currentRun, currentWeight);
        this.messageHandler.sendEventNow(MESSAGE_EVENT.PLAYERSTATUS, notification);
    }

    protected void shutDown() throws Exception {
        log.info("EventsAPIPlugin stopped!");
    }

    @Provides
    EventsAPIConfig provideConfig(ConfigManager configManager) {
        return (EventsAPIConfig)configManager.getConfig(EventsAPIConfig.class);
    }
}

