/*
 * Decompiled with CFR 0.152.
 */
package com.eventsapi;

import com.eventsapi.EventsAPIConfig;
import com.eventsapi.interfaces.ApiConnectable;
import com.eventsapi.interfaces.Sendable;
import com.eventsapi.notifications.BankNotification;
import com.eventsapi.notifications.EquipSlotsNotification;
import com.eventsapi.notifications.EventWrapper;
import com.eventsapi.notifications.InventorySlotsNotification;
import com.eventsapi.notifications.LevelChangeNotification;
import com.eventsapi.notifications.LoginNotification;
import com.eventsapi.notifications.NpcKillNotification;
import com.eventsapi.notifications.QuestChangeNotification;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import net.runelite.api.Client;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiManager
implements ApiConnectable {
    private static final Logger logger = LoggerFactory.getLogger(ApiManager.class);
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private EventsAPIConfig config;
    private final Client client;

    public ApiManager(EventsAPIConfig config, Client client) {
        this.config = config;
        this.client = client;
        logger.debug("Created ApiConnectable ApiManager");
    }

    private void sendHttpPost(final Sendable event) {
        if (!this.canSend(event)) {
            return;
        }
        EventWrapper eventWrapper = event.getEventWrapper();
        UUID uuid = UUID.randomUUID();
        logger.debug("Sending POST request to: " + event.getApiEndpoint());
        logger.debug("UUID: " + uuid.toString());
        logger.debug("Bearer: " + this.config.bearerToken());
        OkHttpClient client = new OkHttpClient();
        Request getRequest = new Request.Builder().url(this.config.apiEndpoint() + event.getApiEndpoint()).header("Authorization", "Bearer: " + this.config.bearerToken()).header("X-Request-Id", uuid.toString()).post(RequestBody.create((MediaType)JSON, (String)eventWrapper.getJsonPayload())).build();
        client.newCall(getRequest).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                e.printStackTrace();
            }

            public void onResponse(Call call, Response response) throws IOException {
                logger.debug("Got response from: " + event.getApiEndpoint());
                logger.debug(response.body().toString());
                response.close();
            }
        });
    }

    public boolean canSend(Sendable event) {
        String endpoint = this.config.apiEndpoint();
        String token = this.config.bearerToken();
        if (endpoint == null) {
            logger.warn("Failed to send, please check endpoint: " + endpoint + " and token: " + token);
            return false;
        }
        if (event instanceof BankNotification) {
            return this.config.emitBankItems();
        }
        if (event instanceof InventorySlotsNotification) {
            return this.config.emitInventory();
        }
        if (event instanceof EquipSlotsNotification) {
            return this.config.emitEquippedItems();
        }
        if (event instanceof LevelChangeNotification) {
            return this.config.enableLevelChange();
        }
        if (event instanceof NpcKillNotification) {
            return this.config.enableMonsterKill();
        }
        if (event instanceof QuestChangeNotification) {
            return this.config.emitQuestInfo();
        }
        if (event instanceof LoginNotification) {
            return this.config.emitLoginState();
        }
        return true;
    }

    @Override
    public void init() {
    }

    @Override
    public void send(Sendable message) {
        this.sendHttpPost(message);
    }

    @Override
    public void send(List<Sendable> messages) {
        for (Sendable message : messages) {
            this.sendHttpPost(message);
        }
    }
}

