/*
 * Decompiled with CFR 0.152.
 */
package dev.dkvl.lastrecall;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

enum RegionShield {
    MISTHALIN("Misthalin", 2731),
    KARAMJA("Karamja", 2732),
    ASGARNIA("Asgarnia", 2733),
    FREMENNIK("Fremennik Province", 2738),
    KANDARIN("Kandarin", 2737),
    DESERT("Kharidian Desert", 2734),
    MORYTANIA("Morytania", 2735),
    TIRANNWN("Tirannwn", 2739),
    WILDERNESS("Wilderness", 2736),
    KOUREND("Great Kourend and Kebos Lowlands", 5468);

    private static Map<String, Integer> SHIELDS;
    private final String region;
    private final int spriteId;

    static int getRegionShield(String region) {
        return SHIELDS.get(region);
    }

    private RegionShield(String region, int spriteId) {
        this.region = region;
        this.spriteId = spriteId;
    }

    public String getRegion() {
        return this.region;
    }

    public int getSpriteId() {
        return this.spriteId;
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (RegionShield shield : RegionShield.values()) {
            builder.put((Object)shield.getRegion(), (Object)shield.getSpriteId());
        }
        SHIELDS = builder.build();
    }
}

