/*
 * Decompiled with CFR 0.152.
 */
package dev.dkvl.lastrecall;

import dev.dkvl.lastrecall.LastRecallConfig;
import dev.dkvl.lastrecall.NamedRegion;
import dev.dkvl.lastrecall.RegionShield;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;

public class MemoryOverlay
extends WidgetItemOverlay {
    private static int WONT_SAVE = 1212;
    private final Client client;
    private final LastRecallConfig config;
    private final TooltipManager tooltipManager;
    private final SpriteManager spriteManager;

    @Inject
    MemoryOverlay(Client client, LastRecallConfig config, TooltipManager tooltipManager, SpriteManager spriteManager) {
        this.client = client;
        this.config = config;
        this.tooltipManager = tooltipManager;
        this.spriteManager = spriteManager;
        this.showOnBank();
        this.showOnInventory();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        if (itemId != 25104 || this.config.region() == null) {
            return;
        }
        Point location = itemWidget.getCanvasLocation();
        int spriteId = RegionShield.getRegionShield(this.config.region());
        BufferedImage shield = this.spriteManager.getSprite(spriteId, 0);
        OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)new Point(location.getX() + 18, location.getY() - 1), (BufferedImage)shield);
        NamedRegion namedRegion = NamedRegion.fromWorldPoint(this.config.location());
        String loc = namedRegion != null ? namedRegion.getName() : this.config.region();
        String tooltip = "Has a teleport to " + ColorUtil.wrapWithColorTag((String)loc, (Color)JagexColors.MENU_TARGET) + ".";
        if (itemWidget.getCanvasBounds().contains(this.client.getMouseCanvasPosition().getX(), this.client.getMouseCanvasPosition().getY())) {
            this.tooltipManager.add(new Tooltip(tooltip));
            if (this.client.isInInstancedRegion()) {
                this.tooltipManager.add(new Tooltip("Teleports from here won't be stored"));
            }
        }
        if (this.client.isInInstancedRegion()) {
            BufferedImage saved = this.spriteManager.getSprite(WONT_SAVE, 0);
            OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)new Point(location.getX() + 18, location.getY() + 18), (BufferedImage)saved);
        }
    }
}

