/*
 * Decompiled with CFR 0.152.
 */
package org.emerycp;

import com.google.inject.Provides;
import java.util.Collection;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemStack;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.loottracker.LootReceived;
import org.emerycp.LootLoggerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Loot Console Logger", description="Let you log loot drops in your message box.")
public class LootLogger
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LootLogger.class);
    String mobKilled = "";
    String itemStack = "";
    String highlightStack = "";
    @Inject
    private Client client;
    @Inject
    private LootLoggerConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;

    @Subscribe
    public void onLootReceived(LootReceived event) {
        this.itemStack = "";
        this.highlightStack = "";
        this.mobKilled = event.getName();
        String[] ignoreList = this.format(this.config.getIgnoreList()).split(",");
        String[] ignoreMonsterList = this.format(this.config.getIgnoreMonster()).split(",");
        String[] highlightList = this.format(this.config.getHighlightList()).split(",");
        Collection iS = event.getItems();
        for (ItemStack i : iS) {
            String currentName = this.client.getItemDefinition(i.getId()).getName();
            String cleanCurrentName = this.format(currentName);
            if (this.config.dropEnabled() && !this.find(ignoreList, cleanCurrentName)) {
                if (!this.itemStack.isEmpty()) {
                    this.itemStack = this.itemStack + " / ";
                }
                this.itemStack = this.itemStack + i.getQuantity() + "x " + currentName;
            }
            if (!this.config.highlightEnabled() || !this.find(highlightList, cleanCurrentName)) continue;
            if (!this.highlightStack.isEmpty()) {
                this.highlightStack = this.highlightStack + " / ";
            }
            this.highlightStack = this.highlightStack + i.getQuantity() + "x " + currentName;
        }
        if (this.config.dropEnabled() && !this.find(ignoreMonsterList, this.format(this.mobKilled)) && !this.itemStack.isEmpty()) {
            this.itemStack = this.itemStack + ".";
            this.sendMessage();
        }
        if (this.config.highlightEnabled() && !this.highlightStack.isEmpty()) {
            this.highlightStack = this.highlightStack + ".";
            this.sendHighlightMessage();
        }
    }

    public void sendMessage() {
        String s = "Drop from " + this.mobKilled + ": " + this.itemStack;
        String formattedMessage = new ChatMessageBuilder().append(this.config.getDropColor(), s).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(formattedMessage).build());
    }

    public void sendHighlightMessage() {
        Object message;
        message = (String)message + (!((String)(message = this.config.getHighlightMessage().trim())).isEmpty() ? ": " : "");
        String formattedMessage = new ChatMessageBuilder().append(this.config.getHighlightColor(), (String)message + this.highlightStack).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(formattedMessage).build());
    }

    public boolean find(String[] st, String s) {
        for (String t : st) {
            if (t.isEmpty() || !s.contains(t)) continue;
            return true;
        }
        return false;
    }

    public String format(String toFormat) {
        return toFormat.toLowerCase().replaceAll("\\s", "");
    }

    @Provides
    LootLoggerConfig provideConfig(ConfigManager configManager) {
        return (LootLoggerConfig)configManager.getConfig(LootLoggerConfig.class);
    }
}

