/*
 * Decompiled with CFR 0.152.
 */
package com.cornertileindicators;

import com.cornertileindicators.CornerTileIndicatorsConfig;
import com.cornertileindicators.CornerTileIndicatorsOverlay;
import com.google.inject.Provides;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.ProfileChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Corner Tile Indicators", description="Tile Indicators Plugin, but only rendering the tile's corners.", conflicts={"Tile Indicators"}, tags={"highlight", "overlay"})
public class CornerTileIndicatorsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CornerTileIndicatorsPlugin.class);
    @Inject
    private CornerTileIndicatorsConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private CornerTileIndicatorsOverlay overlay;
    @Inject
    private ConfigManager configManager;

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.copyBasePluginConfig();
    }

    private void copyBasePluginConfig() {
        if (this.config.mirrorSettings()) {
            for (String key : this.configManager.getConfigurationKeys("tileindicators.")) {
                String value = this.configManager.getConfiguration("tileindicators", key = key.substring("tileindicators.".length()));
                if (value == null) continue;
                this.configManager.setConfiguration("cornertileindicators", key, value);
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (!e.getGroup().equals("cornertileindicators") || !SwingUtilities.isEventDispatchThread()) {
            return;
        }
        if (e.getKey().equals("mirrorSettings") || e.getKey().contains("TileCornersOnly")) {
            return;
        }
        this.configManager.setConfiguration("tileindicators", e.getKey(), e.getNewValue());
    }

    @Subscribe
    public void onProfileChanged(ProfileChanged e) {
        this.copyBasePluginConfig();
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Provides
    CornerTileIndicatorsConfig provideConfig(ConfigManager configManager) {
        return (CornerTileIndicatorsConfig)configManager.getConfig(CornerTileIndicatorsConfig.class);
    }
}

