/*
 * Decompiled with CFR 0.152.
 */
package com.cornertileindicators;

import com.cornertileindicators.CornerTileIndicatorsConfig;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ColorUtil;

public class CornerTileIndicatorsOverlay
extends Overlay {
    private final Client client;
    private final CornerTileIndicatorsConfig config;
    private WorldPoint lastPlayerPosition = new WorldPoint(0, 0, 0);
    private int lastTickPlayerMoved = 0;
    private long lastTimePlayerStoppedMoving = 0L;

    @Inject
    private CornerTileIndicatorsOverlay(Client client, CornerTileIndicatorsConfig config) {
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.MED);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.highlightHoveredTile() && this.client.getSelectedSceneTile() != null) {
            this.renderTile(graphics, this.client.getSelectedSceneTile().getLocalLocation(), this.config.highlightHoveredColor(), this.config.hoveredTileBorderWidth(), this.config.hoveredTileFillColor(), this.config.hoveredTileCornersOnly(), this.config.hoveredTileCornerSize());
        }
        if (this.config.highlightDestinationTile()) {
            this.renderTile(graphics, this.client.getLocalDestinationLocation(), this.config.highlightDestinationColor(), this.config.destinationTileBorderWidth(), this.config.destinationTileFillColor(), this.config.destinationTileCornersOnly(), this.config.destinationTileCornerSize());
        }
        if (this.config.highlightCurrentTile()) {
            WorldPoint playerPos = this.client.getLocalPlayer().getWorldLocation();
            if (!playerPos.equals((Object)this.lastPlayerPosition)) {
                this.lastTickPlayerMoved = this.client.getTickCount();
            } else if (this.lastTickPlayerMoved + 1 == this.client.getTickCount()) {
                this.lastTimePlayerStoppedMoving = System.currentTimeMillis();
            }
            this.lastPlayerPosition = playerPos;
            LocalPoint playerPosLocal = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.lastPlayerPosition);
            if (playerPosLocal != null) {
                Color color = this.config.highlightCurrentColor();
                Color fillColor = this.config.currentTileFillColor();
                if (!this.config.trueTileFadeout() || this.client.getTickCount() - this.lastTickPlayerMoved <= 1) {
                    this.renderTile(graphics, playerPosLocal, color, this.config.currentTileBorderWidth(), fillColor, this.config.currentTileCornersOnly(), this.config.currentTileCornerSize());
                } else {
                    long timeSinceLastMove = System.currentTimeMillis() - this.lastTimePlayerStoppedMoving;
                    int fadeoutTime = this.config.trueTileFadeoutTime() - 600;
                    if (fadeoutTime != 0 && timeSinceLastMove < (long)fadeoutTime) {
                        double opacity = 1.0 - Math.pow((double)timeSinceLastMove / (double)fadeoutTime, 2.0);
                        this.renderTile(graphics, playerPosLocal, ColorUtil.colorWithAlpha((Color)color, (int)((int)(opacity * (double)color.getAlpha()))), this.config.currentTileBorderWidth(), ColorUtil.colorWithAlpha((Color)fillColor, (int)((int)(opacity * (double)fillColor.getAlpha()))), this.config.currentTileCornersOnly(), this.config.currentTileCornerSize());
                    }
                }
            }
        }
        return null;
    }

    private void renderTile(Graphics2D graphics, LocalPoint dest, Color color, double borderWidth, Color fillColor, boolean cornersOnly, int divisor) {
        if (dest == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)dest);
        if (poly == null) {
            return;
        }
        if (cornersOnly) {
            CornerTileIndicatorsOverlay.renderPolygonCorners(graphics, poly, color, fillColor, new BasicStroke((float)borderWidth), divisor);
        } else {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color, (Color)fillColor, (Stroke)new BasicStroke((float)borderWidth));
        }
    }

    public static void renderPolygonCorners(Graphics2D graphics, Polygon poly, Color color, Color fillColor, Stroke borderStroke, int divisor) {
        graphics.setColor(color);
        Stroke originalStroke = graphics.getStroke();
        graphics.setStroke(borderStroke);
        for (int i = 0; i < poly.npoints; ++i) {
            int ptx = poly.xpoints[i];
            int pty = poly.ypoints[i];
            int prev = i - 1 < 0 ? poly.npoints - 1 : i - 1;
            int next = i + 1 > poly.npoints - 1 ? 0 : i + 1;
            int ptxN = (poly.xpoints[next] - ptx) / divisor + ptx;
            int ptyN = (poly.ypoints[next] - pty) / divisor + pty;
            int ptxP = (poly.xpoints[prev] - ptx) / divisor + ptx;
            int ptyP = (poly.ypoints[prev] - pty) / divisor + pty;
            graphics.drawLine(ptx, pty, ptxN, ptyN);
            graphics.drawLine(ptx, pty, ptxP, ptyP);
        }
        graphics.setColor(fillColor);
        graphics.fill(poly);
        graphics.setStroke(originalStroke);
    }
}

