/*
 * Decompiled with CFR 0.152.
 */
package com.cornertileindicators;

import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;
import net.runelite.client.config.Units;

@ConfigGroup(value="cornertileindicators")
public interface CornerTileIndicatorsConfig
extends Config {
    @ConfigSection(name="Destination Tile", description="Destination tile configuration", position=0)
    public static final String destinationTile = "destinationTile";
    @ConfigSection(name="Hovered Tile", description="Hovered tile configuration", position=1)
    public static final String hoveredTile = "hoveredTile";
    @ConfigSection(name="Current Tile", description="Current tile configuration", position=2)
    public static final String currentTile = "currentTile";
    @ConfigSection(name="Extra configuration", description="", closedByDefault=true, position=10)
    public static final String extra = "extra";

    @ConfigItem(keyName="highlightDestinationTile", name="Highlight destination tile", description="Highlights tile player is walking to", position=1, section="destinationTile")
    default public boolean highlightDestinationTile() {
        return true;
    }

    @Alpha
    @ConfigItem(keyName="highlightDestinationColor", name="Highlight color", description="Configures the highlight color of current destination", position=2, section="destinationTile")
    default public Color highlightDestinationColor() {
        return Color.GRAY;
    }

    @Alpha
    @ConfigItem(keyName="destinationTileFillColor", name="Fill color", description="Configures the fill color of destination tile", position=3, section="destinationTile")
    default public Color destinationTileFillColor() {
        return new Color(0, 0, 0, 50);
    }

    @ConfigItem(keyName="destinationTileBorderWidth", name="Border width", description="Width of the destination tile marker border", position=4, section="destinationTile")
    default public double destinationTileBorderWidth() {
        return 2.0;
    }

    @ConfigItem(keyName="destinationTileCornersOnly", name="Corners only", description="Draw only the corners of the destination tile.", position=5, section="destinationTile")
    default public boolean destinationTileCornersOnly() {
        return false;
    }

    @ConfigItem(keyName="highlightHoveredTile", name="Highlight hovered tile", description="Highlights tile player is hovering with mouse", position=1, section="hoveredTile")
    default public boolean highlightHoveredTile() {
        return false;
    }

    @Alpha
    @ConfigItem(keyName="highlightHoveredColor", name="Highlight color", description="Configures the highlight color of hovered tile", position=2, section="hoveredTile")
    default public Color highlightHoveredColor() {
        return new Color(0, 0, 0, 0);
    }

    @Alpha
    @ConfigItem(keyName="hoveredTileFillColor", name="Fill color", description="Configures the fill color of hovered tile", position=3, section="hoveredTile")
    default public Color hoveredTileFillColor() {
        return new Color(0, 0, 0, 50);
    }

    @ConfigItem(keyName="hoveredTileBorderWidth", name="Border width", description="Width of the hovered tile marker border", position=4, section="hoveredTile")
    default public double hoveredTileBorderWidth() {
        return 2.0;
    }

    @ConfigItem(keyName="hoveredTileCornersOnly", name="Corners only", description="Draw only the corners of the hovered tile.", position=5, section="hoveredTile")
    default public boolean hoveredTileCornersOnly() {
        return false;
    }

    @ConfigItem(keyName="highlightCurrentTile", name="Highlight true tile", description="Highlights true tile player is on as seen by server", position=1, section="currentTile")
    default public boolean highlightCurrentTile() {
        return false;
    }

    @Alpha
    @ConfigItem(keyName="highlightCurrentColor", name="Highlight color", description="Configures the highlight color of current true tile", position=2, section="currentTile")
    default public Color highlightCurrentColor() {
        return Color.CYAN;
    }

    @Alpha
    @ConfigItem(keyName="currentTileFillColor", name="Fill color", description="Configures the fill color of current true tile", position=3, section="currentTile")
    default public Color currentTileFillColor() {
        return new Color(0, 0, 0, 50);
    }

    @ConfigItem(keyName="currentTileBorderWidth", name="Border width", description="Width of the true tile marker border", position=4, section="currentTile")
    default public double currentTileBorderWidth() {
        return 2.0;
    }

    @ConfigItem(keyName="currentTileCornersOnly", name="Corners only", description="Draw only the corners of the current tile.", position=5, section="currentTile")
    default public boolean currentTileCornersOnly() {
        return false;
    }

    @ConfigItem(keyName="trueTileFadeout", name="Fadeout", description="Fade out the true tile once the player stops moving.", position=5, section="currentTile")
    default public boolean trueTileFadeout() {
        return false;
    }

    @ConfigItem(keyName="trueTileFadeoutTime", name="Fadeout time", description="Milliseconds that the true tile is drawn for after moving. Minimum is 600 (1 game tick).", position=6, section="currentTile")
    @Range(min=600)
    @Units(value="ms")
    default public int trueTileFadeoutTime() {
        return 800;
    }

    @ConfigItem(keyName="mirrorSettings", name="Mirror settings", description="Copy settings between this plugin and the normal Tile Indicators plugin.", position=100)
    default public boolean mirrorSettings() {
        return true;
    }

    @ConfigItem(keyName="hoveredTileCornerSize", name="Hovered Corner Size", description="Larger values make it smaller.", section="extra", position=10)
    default public int hoveredTileCornerSize() {
        return 5;
    }

    @ConfigItem(keyName="destinationTileCornerSize", name="Destination Corner Size", description="Larger values make it smaller.", section="extra", position=10)
    default public int destinationTileCornerSize() {
        return 5;
    }

    @ConfigItem(keyName="currentTileCornerSize", name="Current Corner Size", description="Larger values make it smaller.", section="extra", position=10)
    default public int currentTileCornerSize() {
        return 5;
    }
}

