/*
 * Decompiled with CFR 0.152.
 */
package com.dynamicentityhider;

import com.dynamicentityhider.DynamicEntityHiderConfig;
import com.dynamicentityhider.config.Mode;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Renderable;
import net.runelite.client.callback.Hooks;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Dynamic Entity Hider", description="Hides players when there are too many showing")
public class DynamicEntityHiderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DynamicEntityHiderPlugin.class);
    @Inject
    private Client client;
    @Inject
    private DynamicEntityHiderConfig config;
    @Inject
    private Hooks hooks;
    private long prevTime = System.currentTimeMillis();
    private List<Player> playersToShow = new ArrayList<Player>();
    private List<Player> prevPlayersToShow = new ArrayList<Player>();
    private final Hooks.RenderableDrawListener drawListener = this::shouldDraw;

    @Provides
    DynamicEntityHiderConfig provideConfig(ConfigManager configManager) {
        return (DynamicEntityHiderConfig)configManager.getConfig(DynamicEntityHiderConfig.class);
    }

    protected void startUp() {
        this.playersToShow = new ArrayList<Player>();
        this.hooks.registerRenderableDrawListener(this.drawListener);
    }

    protected void shutDown() {
        this.hooks.unregisterRenderableDrawListener(this.drawListener);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (e.getGroup().equals("dynamicentityhider") && e.getNewValue().equals(Mode.RANDOM.toString())) {
            this.playersToShow = new ArrayList<Player>();
        }
    }

    @VisibleForTesting
    boolean shouldDraw(Renderable renderable, boolean drawingUI) {
        NPC npc;
        boolean playerInWilderness;
        if (!this.client.isClientThread()) {
            return true;
        }
        boolean bl = playerInWilderness = this.client.getVarbitValue(5963) == 1;
        if (this.config.disableInWilderness() && playerInWilderness) {
            return true;
        }
        Player local = this.client.getLocalPlayer();
        if (this.prevTime != System.currentTimeMillis()) {
            this.prevTime = System.currentTimeMillis();
            this.prevPlayersToShow = new ArrayList<Player>(this.playersToShow);
            this.playersToShow = this.client.getPlayers();
            this.playersToShow.remove(local);
            if (this.config.mode().equals((Object)Mode.DISTANCE)) {
                this.playersToShow.sort(new SortByDistance());
            } else if (this.config.mode().equals((Object)Mode.RANDOM)) {
                ArrayList<Player> retainPlayersToShow = new ArrayList<Player>(this.playersToShow);
                retainPlayersToShow.retainAll(this.prevPlayersToShow);
                ArrayList<Player> newPlayersToShow = new ArrayList<Player>(this.playersToShow);
                newPlayersToShow.removeAll(retainPlayersToShow);
                Collections.shuffle(newPlayersToShow);
                this.playersToShow = new ArrayList<Player>(retainPlayersToShow);
                this.playersToShow.addAll(newPlayersToShow);
            }
            if (this.config.maxPlayersShown() < this.playersToShow.size()) {
                this.playersToShow = this.playersToShow.subList(0, this.config.maxPlayersShown());
            }
        }
        if (renderable instanceof Player) {
            Player player = (Player)renderable;
            if (player != local) {
                return this.playersToShow.contains(player);
            }
        } else if (renderable instanceof NPC && (npc = (NPC)renderable).getComposition().isFollower() && npc != this.client.getFollower()) {
            return this.playersToShow.contains(npc.getInteracting());
        }
        return true;
    }

    class SortByDistance
    implements Comparator<Player> {
        SortByDistance() {
        }

        @Override
        public int compare(Player a, Player b) {
            return DynamicEntityHiderPlugin.this.client.getLocalPlayer().getLocalLocation().distanceTo(a.getLocalLocation()) - DynamicEntityHiderPlugin.this.client.getLocalPlayer().getLocalLocation().distanceTo(b.getLocalLocation());
        }
    }
}

