/*
 * Decompiled with CFR 0.152.
 */
package com.emojiscape;

import com.emojiscape.IconMode;
import com.emojiscape.RSEmoji;
import com.emojiscape.emojiscapeConfig;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import joptsimple.internal.Strings;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.IndexedSprite;
import net.runelite.api.MessageNode;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="EmojiScape", description="Adds Runescape icons to chat")
public class emojiscapePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(emojiscapePlugin.class);
    private static final Pattern TAG_REGEXP = Pattern.compile("<[^>]*>");
    private static final Pattern WHITESPACE_REGEXP = Pattern.compile("[\\s\\u00A0]");
    private static final Pattern SLASH_REGEXP = Pattern.compile("[\\/]");
    private static final Pattern PUNCTUATION_REGEXP = Pattern.compile("[\\W\\_\\d]");
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private emojiscapeConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    private int modIconsStart = -1;

    protected void startUp() {
        this.clientThread.invokeLater(this::loadRSEmojiIcons);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.loadRSEmojiIcons();
        }
    }

    private void loadRSEmojiIcons() {
        IndexedSprite[] modIcons = this.client.getModIcons();
        if (this.modIconsStart != -1 || modIcons == null) {
            return;
        }
        RSEmoji[] RSEmojis = RSEmoji.values();
        IndexedSprite[] newModIcons = Arrays.copyOf(modIcons, modIcons.length + RSEmojis.length);
        this.modIconsStart = modIcons.length;
        for (int i = 0; i < RSEmojis.length; ++i) {
            RSEmoji RSEmoji2 = RSEmojis[i];
            try {
                IndexedSprite sprite;
                BufferedImage image = RSEmoji2.loadImage(RSEmoji2);
                newModIcons[this.modIconsStart + i] = sprite = ImageUtil.getImageIndexedSprite((BufferedImage)image, (Client)this.client);
                continue;
            }
            catch (Exception ex) {
                log.warn("Failed to load the sprite for RSEmoji " + RSEmoji2, (Throwable)ex);
            }
        }
        log.debug("Adding RSEmoji icons");
        this.client.setModIcons(newModIcons);
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.modIconsStart == -1) {
            return;
        }
        switch (chatMessage.getType()) {
            case PUBLICCHAT: 
            case MODCHAT: 
            case FRIENDSCHAT: 
            case PRIVATECHAT: 
            case PRIVATECHATOUT: 
            case MODPRIVATECHAT: {
                break;
            }
            default: {
                return;
            }
        }
        MessageNode messageNode = chatMessage.getMessageNode();
        String message = messageNode.getValue();
        String updatedMessage = this.updateMessage(message);
        if (updatedMessage == null) {
            return;
        }
        messageNode.setRuneLiteFormatMessage(updatedMessage);
        this.chatMessageManager.update(messageNode);
        this.client.refreshChat();
    }

    @Subscribe
    public void onOverheadTextChanged(OverheadTextChanged event) {
        if (!(event.getActor() instanceof Player)) {
            return;
        }
        String message = event.getOverheadText();
        String updatedMessage = this.updateMessage(message);
        if (updatedMessage == null) {
            return;
        }
        event.getActor().setOverheadText(updatedMessage);
    }

    @Nullable
    String updateMessage(String message) {
        String surroundRight;
        String surroundLeft;
        switch (this.config.afterTextStyle()) {
            case ROUND: {
                surroundLeft = "(";
                surroundRight = ")";
                break;
            }
            case SQUARE: {
                surroundLeft = "[";
                surroundRight = "]";
                break;
            }
            default: {
                surroundLeft = "";
                surroundRight = "";
            }
        }
        String[] slashWords = SLASH_REGEXP.split(message);
        boolean editedMessage = false;
        for (int s = 0; s < slashWords.length; ++s) {
            String[] messageWords = WHITESPACE_REGEXP.split(slashWords[s]);
            for (int i = 0; i < messageWords.length; ++i) {
                boolean longTriggerUsed = false;
                boolean editWord = false;
                String pretrigger = emojiscapePlugin.removeTags(messageWords[i]);
                Matcher matcherTrigger = PUNCTUATION_REGEXP.matcher(pretrigger);
                String trigger = matcherTrigger.replaceAll("");
                if (trigger.equals("")) continue;
                RSEmoji rsEmoji = RSEmoji.getRSEmoji(trigger.toLowerCase());
                RSEmoji rsShortEmoji = RSEmoji.getShortRSEmoji(trigger.toLowerCase());
                if (rsEmoji == null && rsShortEmoji == null) continue;
                boolean skillLong = false;
                boolean skillShort = false;
                boolean miscLong = false;
                boolean miscShort = false;
                switch (this.config.skillIcons()) {
                    case LONG: {
                        skillLong = true;
                        break;
                    }
                    case SHORT: {
                        skillShort = true;
                        break;
                    }
                    case BOTH: {
                        skillLong = true;
                        skillShort = true;
                    }
                }
                switch (this.config.miscIcons()) {
                    case LONG: {
                        miscLong = true;
                        break;
                    }
                    case SHORT: {
                        miscShort = true;
                        break;
                    }
                    case BOTH: {
                        miscLong = true;
                        miscShort = true;
                    }
                }
                int rsEmojiId = 0;
                if (rsEmoji != null) {
                    rsEmojiId = this.modIconsStart + rsEmoji.ordinal();
                    if (skillLong && rsEmoji.ordinal() <= 24 || this.config.prayerIcons() && 25 <= rsEmoji.ordinal() && rsEmoji.ordinal() <= 32 || miscLong && 33 <= rsEmoji.ordinal() && rsEmoji.ordinal() <= 51) {
                        editWord = true;
                    }
                    longTriggerUsed = true;
                }
                if (rsShortEmoji != null && !longTriggerUsed) {
                    rsEmojiId = this.modIconsStart + rsShortEmoji.ordinal();
                    if (skillShort && rsShortEmoji.ordinal() <= 24 || this.config.prayerIcons() && 25 <= rsShortEmoji.ordinal() && rsShortEmoji.ordinal() <= 32 || miscShort && 33 <= rsShortEmoji.ordinal() && rsShortEmoji.ordinal() <= 51) {
                        editWord = true;
                    }
                }
                if (editWord && rsEmojiId != 0) {
                    if (this.config.swapIconMode() == IconMode.REPLACE) {
                        messageWords[i] = messageWords[i].replace(trigger, "<img=" + rsEmojiId + ">");
                    } else if (this.config.swapIconMode() == IconMode.APPEND) {
                        messageWords[i] = messageWords[i].replace(trigger, trigger + surroundLeft + "<img=" + rsEmojiId + ">" + surroundRight);
                    }
                }
                editedMessage = true;
            }
            slashWords[s] = Strings.join((String[])messageWords, (String)" ");
        }
        if (!editedMessage) {
            return null;
        }
        return Strings.join((String[])slashWords, (String)"/");
    }

    private static String removeTags(String str) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = TAG_REGEXP.matcher(str);
        while (matcher.find()) {
            String match;
            matcher.appendReplacement(stringBuffer, "");
            switch (match = matcher.group(0)) {
                case "<lt>": 
                case "<gt>": {
                    stringBuffer.append(match);
                }
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    @Provides
    emojiscapeConfig provideConfig(ConfigManager configManager) {
        return (emojiscapeConfig)configManager.getConfig(emojiscapeConfig.class);
    }
}

