/*
 * Decompiled with CFR 0.152.
 */
package com.emojiscape;

import com.google.common.collect.ImmutableMap;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import net.runelite.client.RuneLite;
import net.runelite.client.util.ImageUtil;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum RSEmoji {
    AGILITY,
    ATTACK,
    COMBAT,
    MELEE,
    CONSTRUCTION,
    COOKING,
    CRAFTING,
    DEFENCE,
    FARMING,
    FIREMAKING,
    FISHING,
    FLETCHING,
    HERBLORE,
    HITPOINTS,
    HUNTER,
    MAGIC,
    MINING,
    PRAYER,
    RANGED,
    RUNECRAFT,
    SLAYER,
    SMITHING,
    STRENGTH,
    THIEVING,
    WOODCUTTING,
    RETRIBUTION,
    REDEMPTION,
    SMITE,
    PRESERVE,
    CHIVALRY,
    PIETY,
    RIGOUR,
    AUGURY,
    BANK,
    ALTAR,
    SHORTCUT,
    QUEST,
    DIARY,
    MINIGAME,
    FAVOUR,
    ARCEUUS,
    HOSIDIUS,
    LOVAKENGJ,
    PISCARILIUS,
    SHAYZIEN,
    COINS,
    EXCHANGE,
    IRONMAN,
    HARDCORE,
    ULTIMATE,
    JMOD,
    PMOD;

    private static final Logger log;
    private static final Map<String, RSEmoji> skillLongEmojiMap;
    private static final Map<String, RSEmoji> skillShortEmojiMap;

    public String getProperty(String LongorShort) throws IOException {
        int failCount = 0;
        int maxFails = 3;
        Properties prop = new Properties();
        while (true) {
            try {
                prop.load(new FileInputStream(RuneLite.RUNELITE_DIR + "/emojiscape.properties"));
            }
            catch (Exception e) {
                URL inputURL = ((Object)((Object)this)).getClass().getResource("/emojiscape.properties");
                File dest = new File(RuneLite.RUNELITE_DIR + "/emojiscape.properties");
                log.error("Could not find emojiscape.properties so creating it at: " + dest.getAbsolutePath());
                FileUtils.copyURLToFile(inputURL, dest);
                if (++failCount != maxFails) continue;
                throw e;
            }
            break;
        }
        return prop.getProperty(this.name() + "." + LongorShort);
    }

    public String[] longTrigger() throws IOException {
        return this.getProperty("LongTrigger").split("\\s*,\\s*");
    }

    public String[] shortTrigger() throws IOException {
        return this.getProperty("ShortTrigger").split("\\s*,\\s*");
    }

    BufferedImage loadImage(RSEmoji rsEmoji) {
        switch (rsEmoji) {
            case AGILITY: 
            case ATTACK: 
            case COMBAT: 
            case CONSTRUCTION: 
            case COOKING: 
            case CRAFTING: 
            case DEFENCE: 
            case FARMING: 
            case FIREMAKING: 
            case FISHING: 
            case FLETCHING: 
            case HERBLORE: 
            case HITPOINTS: 
            case HUNTER: 
            case MAGIC: 
            case MELEE: 
            case MINING: 
            case PRAYER: 
            case RANGED: 
            case RUNECRAFT: 
            case SLAYER: 
            case SMITHING: 
            case STRENGTH: 
            case THIEVING: 
            case WOODCUTTING: {
                return ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)("/Skills/" + this.name().toLowerCase() + ".png"));
            }
            case AUGURY: 
            case CHIVALRY: 
            case PIETY: 
            case PRESERVE: 
            case REDEMPTION: 
            case RETRIBUTION: 
            case RIGOUR: 
            case SMITE: {
                return ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)("/Prayers/" + this.name().toLowerCase() + ".png"));
            }
        }
        return ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)("/Misc/" + this.name().toLowerCase() + ".png"));
    }

    public static RSEmoji getRSEmoji(String longTrigger) {
        return skillLongEmojiMap.get(longTrigger);
    }

    public static RSEmoji getShortRSEmoji(String shortTrigger) {
        return skillShortEmojiMap.get(shortTrigger);
    }

    static {
        log = LoggerFactory.getLogger(RSEmoji.class);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (RSEmoji RSEmoji2 : RSEmoji.values()) {
            try {
                for (int i = 0; i < RSEmoji2.longTrigger().length; ++i) {
                    builder.put((Object)RSEmoji2.longTrigger()[i], (Object)RSEmoji2);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        skillLongEmojiMap = builder.build();
        builder = new ImmutableMap.Builder();
        for (RSEmoji RSEmoji2 : RSEmoji.values()) {
            try {
                for (int i = 0; i < RSEmoji2.shortTrigger().length; ++i) {
                    builder.put((Object)RSEmoji2.shortTrigger()[i], (Object)RSEmoji2);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        skillShortEmojiMap = builder.build();
    }
}

