/*
 * Decompiled with CFR 0.152.
 */
package com.apm;

import com.apm.ApmConfig;
import com.apm.ApmKeyListener;
import com.apm.ApmMouseListener;
import com.apm.ApmOverlay;
import com.google.inject.Provides;
import java.util.LinkedList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.WidgetClosed;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="APM")
public class ApmPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ApmPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ApmConfig config;
    @Inject
    OverlayManager overlayManager;
    @Inject
    ApmOverlay overlay;
    @Inject
    private KeyManager keyManager;
    private ApmKeyListener keyListener;
    @Inject
    private MouseManager mouseManager;
    private ApmMouseListener mouseListener;
    public int totalInputCount;
    public int seconds;
    public int inputCountSecond;
    private final LinkedList<Integer> pastMinuteInputs = new LinkedList();
    private final int numCells = 60;
    public int currentApm = 0;
    public int max;
    public int min = 0;
    @Inject
    private ScheduledExecutorService executorService;
    private ScheduledFuture updateChartFuture;

    protected void startUp() throws Exception {
        this.pastMinuteInputs.clear();
        for (int i = 0; i < 60; ++i) {
            this.pastMinuteInputs.add(0);
        }
        this.overlayManager.add((Overlay)this.overlay);
        this.updateChartFuture = this.executorService.scheduleAtFixedRate(this::updateChart, 0L, 1L, TimeUnit.SECONDS);
        this.keyListener = new ApmKeyListener(this, this.config);
        this.keyManager.registerKeyListener((KeyListener)this.keyListener);
        this.mouseListener = new ApmMouseListener(this, this.config);
        this.mouseManager.registerMouseListener((MouseListener)this.mouseListener);
        this.inputCountSecond = 0;
        this.totalInputCount = 0;
        this.seconds = 0;
        log.info("APM started!");
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.updateChartFuture.cancel(true);
        this.updateChartFuture = null;
        this.keyManager.unregisterKeyListener((KeyListener)this.keyListener);
        this.keyListener = null;
        this.mouseManager.unregisterMouseListener((MouseListener)this.mouseListener);
        this.mouseListener = null;
        this.pastMinuteInputs.clear();
        log.info("APM stopped!");
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed widgetClosed) {
        if (widgetClosed.getGroupId() == 378) {
            this.inputCountSecond = 0;
            this.totalInputCount = 0;
            this.seconds = 0;
            this.pastMinuteInputs.clear();
            for (int i = 0; i < 60; ++i) {
                this.pastMinuteInputs.add(0);
            }
        }
    }

    public void updateChart() {
        this.pastMinuteInputs.add(this.inputCountSecond);
        this.pastMinuteInputs.remove();
        ++this.seconds;
        this.inputCountSecond = 0;
        int hold = 0;
        for (Integer integer : this.pastMinuteInputs) {
            hold += integer.intValue();
        }
        this.currentApm = hold;
        this.max = this.getMax();
        this.min = this.getMin();
    }

    private Integer getMax() {
        Integer currentMax = 0;
        for (Integer integer : this.pastMinuteInputs) {
            if (integer <= currentMax) continue;
            currentMax = integer;
        }
        return currentMax;
    }

    private Integer getMin() {
        Integer currentMin = 0;
        for (Integer integer : this.pastMinuteInputs) {
            if (integer >= currentMin) continue;
            currentMin = integer;
        }
        return currentMin;
    }

    @Provides
    ApmConfig provideConfig(ConfigManager configManager) {
        return (ApmConfig)configManager.getConfig(ApmConfig.class);
    }

    public LinkedList<Integer> getPastMinuteInputs() {
        return this.pastMinuteInputs;
    }
}

