/*
 * Decompiled with CFR 0.152.
 */
package com.apm;

import com.apm.ApmConfig;
import com.apm.ApmPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.LinkedList;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;

public class ApmOverlay
extends OverlayPanel {
    private final ApmPlugin plugin;
    private final ApmConfig config;
    LayoutableRenderableEntity apmGraph = new LayoutableRenderableEntity(){

        public Dimension render(Graphics2D graphics) {
            int overlayHeight;
            int overlayWidth;
            block19: {
                double round;
                int tempMax;
                int height;
                int width;
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                if (ApmOverlay.this.config.toggleBehind()) {
                    ApmOverlay.this.setLayer(OverlayLayer.ABOVE_SCENE);
                } else {
                    ApmOverlay.this.setLayer(OverlayLayer.ABOVE_WIDGETS);
                }
                try {
                    overlayWidth = ApmOverlay.this.getPreferredSize().width;
                    overlayHeight = ApmOverlay.this.getPreferredSize().height;
                }
                catch (NullPointerException e) {
                    overlayWidth = 180;
                    overlayHeight = 60;
                    ApmOverlay.this.setPreferredSize(new Dimension(overlayWidth, overlayHeight));
                }
                int marginGraphHeight = ApmOverlay.this.config.fontSize();
                int marginGraphWidth = 10;
                if (ApmOverlay.this.config.hideMargin()) {
                    width = overlayWidth;
                    height = overlayHeight - marginGraphHeight;
                } else {
                    width = overlayWidth - marginGraphWidth * 2;
                    height = overlayHeight - (marginGraphHeight + 15);
                }
                if (ApmOverlay.this.config.hideGraph()) {
                    width = 0;
                    height = 0;
                    overlayHeight = ApmOverlay.this.config.fontSize();
                }
                graphics.setColor(ApmOverlay.this.config.overlayBackgroundColor());
                graphics.fillRect(0, 0, overlayWidth, overlayHeight);
                graphics.setColor(ApmOverlay.this.config.overlayBorderColor());
                graphics.drawRect(0, 0, overlayWidth, overlayHeight);
                graphics.setColor(ApmOverlay.this.config.graphBorderColor());
                int val = ApmOverlay.this.config.hideMargin() ? 0 : marginGraphWidth - 1;
                graphics.drawRect(val, marginGraphHeight + 1, width, height);
                graphics.setColor(ApmOverlay.this.config.graphBackgroundColor());
                graphics.fillRect(val, marginGraphHeight + 1, width, height);
                graphics.setColor(ApmOverlay.this.config.textColor());
                String fontName = "Runescape Small";
                Font userFont = new Font(fontName, ApmOverlay.this.config.fontStyle().getValue(), ApmOverlay.this.config.fontSize());
                graphics.setFont(userFont);
                String rightLabel = "APM: " + ApmOverlay.this.plugin.currentApm;
                int strWidth = graphics.getFontMetrics().stringWidth(rightLabel);
                graphics.drawString(rightLabel, overlayWidth - strWidth - marginGraphWidth, marginGraphHeight - 1);
                Object leftLabel = "?";
                leftLabel = ApmOverlay.this.plugin.seconds < 60 ? "Session APM: " + ApmOverlay.this.plugin.currentApm : "Session APM: " + (int)((double)ApmOverlay.this.plugin.totalInputCount / ((double)ApmOverlay.this.plugin.seconds / 60.0));
                graphics.drawString((String)leftLabel, marginGraphWidth, marginGraphHeight - 1);
                LinkedList<Integer> data = ApmOverlay.this.plugin.getPastMinuteInputs();
                int dataStart = data.size() > overlayWidth ? data.size() - overlayWidth : 0;
                int maxValue = ApmOverlay.this.plugin.max;
                int minValue = ApmOverlay.this.plugin.min;
                if (maxValue <= 0) {
                    maxValue = 10;
                }
                if ((double)((maxValue = (int)(Math.ceil((double)(tempMax = maxValue) / (round = maxValue > 50 ? 50.0 : 10.0)) * round)) - tempMax) <= 0.2 * (double)maxValue) {
                    maxValue = (int)((double)maxValue + round);
                }
                if (maxValue == minValue) {
                    ++maxValue;
                    --minValue;
                }
                if (ApmOverlay.this.config.hideGraph()) break block19;
                if (ApmOverlay.this.config.chartType().getValue().equals("Bar")) {
                    graphics.setColor(ApmOverlay.this.config.graphColor());
                    for (int i = dataStart; i < data.size(); ++i) {
                        int y = data.get(i);
                        int barWidth = !ApmOverlay.this.config.hideMargin() ? (overlayWidth - marginGraphWidth) / 60 : overlayWidth / 60;
                        y = y < 0 ? maxValue - 1 : y;
                        y = height - ((height - 2) * (y - minValue) / (maxValue - minValue) + 1);
                        int tempX = width * (i - dataStart) / (data.size() - dataStart);
                        y += marginGraphHeight;
                        if (!ApmOverlay.this.config.hideMargin()) {
                            tempX += marginGraphWidth;
                        }
                        graphics.setColor(ApmOverlay.this.config.graphColor());
                        if (!ApmOverlay.this.config.hideMargin()) {
                            graphics.drawRect(tempX, y, barWidth, overlayHeight - marginGraphHeight - y);
                            graphics.fillRect(tempX, y, barWidth, overlayHeight - marginGraphHeight - y);
                            continue;
                        }
                        graphics.drawRect(tempX, y, barWidth, overlayHeight - y);
                        graphics.fillRect(tempX, y, barWidth, overlayHeight - y);
                    }
                } else {
                    graphics.setColor(ApmOverlay.this.config.graphColor());
                    int oldX = -1;
                    int oldY = -1;
                    for (int x = dataStart; x < data.size(); ++x) {
                        int y = data.get(x);
                        y = y < 0 ? maxValue - 1 : y;
                        y = height - ((height - 2) * (y - minValue) / (maxValue - minValue) + 1);
                        int tempX = width * (x - dataStart) / (data.size() - dataStart);
                        y += marginGraphHeight;
                        if (!ApmOverlay.this.config.hideMargin()) {
                            tempX += marginGraphWidth;
                        }
                        if (y >= 0) {
                            graphics.drawLine(tempX, y, tempX, y);
                        }
                        if (oldX != -1 && y >= 0) {
                            graphics.drawLine(oldX, oldY, tempX, y);
                        }
                        oldX = tempX;
                        oldY = y;
                    }
                }
            }
            return new Dimension(overlayWidth - 8, overlayHeight - 8);
        }

        public Rectangle getBounds() {
            return null;
        }

        public void setPreferredLocation(Point position) {
        }

        public void setPreferredSize(Dimension dimension) {
        }
    };

    @Inject
    public ApmOverlay(ApmPlugin plugin, ApmConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.render(graphics);
        this.panelComponent.getChildren().add(this.apmGraph);
        this.panelComponent.setBackgroundColor(new Color(0, 0, 0, 0));
        return super.render(graphics);
    }
}

