/*
 * Decompiled with CFR 0.152.
 */
package com.sorgrum.toamissingpickaxeindicator;

import com.sorgrum.toamissingpickaxeindicator.ToaMissingPickaxeIndicatorConfig;
import com.sorgrum.toamissingpickaxeindicator.ToaMissingPickaxeIndicatorPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.SplitComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MissingPickaxeOverlay
extends OverlayPanel {
    private static final Logger log = LoggerFactory.getLogger(MissingPickaxeOverlay.class);
    private final Client client;
    private final ToaMissingPickaxeIndicatorConfig config;
    @Inject
    private ItemManager itemManager;

    @Inject
    private MissingPickaxeOverlay(ToaMissingPickaxeIndicatorPlugin plugin, ToaMissingPickaxeIndicatorConfig config, Client client) {
        super((Plugin)plugin);
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_CENTER);
        this.setPriority(OverlayPriority.HIGHEST);
    }

    public boolean inParty() {
        return this.client.getVarbitValue(14345) == 1;
    }

    public boolean hasStoredPickaxe() {
        return this.client.getVarbitValue(14440) != 0;
    }

    public boolean inLobby() {
        return Arrays.stream(this.client.getMapRegions()).anyMatch(region -> region == 14160);
    }

    public boolean inBankArea() {
        return Arrays.stream(this.client.getMapRegions()).anyMatch(region -> region == 13454);
    }

    public boolean hasPickaxeInInventory() {
        ItemContainer container = this.client.getItemContainer(InventoryID.INVENTORY);
        if (container == null) {
            return false;
        }
        return Arrays.stream(container.getItems()).anyMatch(item -> this.itemManager.getItemComposition(item.getId()).getName().toLowerCase().contains("pickaxe"));
    }

    public boolean hasPickaxeEquipped() {
        ItemContainer container = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (container == null) {
            return false;
        }
        return Arrays.stream(container.getItems()).anyMatch(item -> this.itemManager.getItemComposition(item.getId()).getName().toLowerCase().contains("pickaxe"));
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.notifyInParty() && !this.inParty()) {
            return null;
        }
        if (this.hasStoredPickaxe()) {
            return null;
        }
        if (this.config.notifyInTombs() && !this.inLobby() && !this.inBankArea()) {
            return null;
        }
        if (this.hasPickaxeInInventory() || this.hasPickaxeEquipped()) {
            return null;
        }
        this.panelComponent.setBackgroundColor(new Color(140, 10, 10));
        this.panelComponent.setPreferredSize(new Dimension(300, 0));
        this.panelComponent.getChildren().add(SplitComponent.builder().first((LayoutableRenderableEntity)new ImageComponent((BufferedImage)this.itemManager.getImage(11920))).second((LayoutableRenderableEntity)SplitComponent.builder().first((LayoutableRenderableEntity)LineComponent.builder().build()).second((LayoutableRenderableEntity)SplitComponent.builder().first((LayoutableRenderableEntity)TitleComponent.builder().text("No pickaxe stored in Tombs of Amascut").build()).second((LayoutableRenderableEntity)LineComponent.builder().build()).build()).build()).orientation(ComponentOrientation.HORIZONTAL).build());
        return super.render(graphics);
    }
}

