/*
 * Decompiled with CFR 0.152.
 */
package com.unmoon;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.inject.Inject;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Forsen Lines")
public class ForsenLines
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ForsenLines.class);
    @Inject
    private Client client;
    private static final List<String> death_sounds = Arrays.asList("deathScreen_respawn.wav", "deathScreen_title.wav", "death_attack_fall.wav", "death_attack_lava.wav", "death_attack_onFire.wav", "death_fell_accident_generic.wav");

    protected void startUp() throws Exception {
        this.playSound("narrator_screen_title.wav");
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGING_IN) {
            this.playSound("menu_game.wav");
        }
    }

    private void playSound(String sound_name) {
        InputStream stream = ForsenLines.class.getResourceAsStream(sound_name);
        if (stream == null) {
            log.warn("Failed to load sound '{}' (null)", (Object)sound_name);
            return;
        }
        try {
            BufferedInputStream fileStream = new BufferedInputStream(stream);
            AudioInputStream sound = AudioSystem.getAudioInputStream(fileStream);
            Clip clip = AudioSystem.getClip();
            clip.open(sound);
            clip.loop(0);
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            log.warn("Failed to play sound '{}'", (Object)sound_name, (Object)e);
        }
    }

    public String getRandomElement(List<String> list) {
        Random rand = new Random();
        return list.get(rand.nextInt(list.size()));
    }

    @Subscribe
    public void onActorDeath(ActorDeath event) {
        Player player;
        Actor actor = event.getActor();
        if (actor instanceof Player && (player = (Player)actor) == this.client.getLocalPlayer()) {
            this.playSound(this.getRandomElement(death_sounds));
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String message;
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        switch (message = event.getMessage()) {
            case "You failed to survive the Tombs of Amascut.": {
                this.playSound("menu_returnToMenu.wav");
                return;
            }
            case "You enter the Tombs of Amascut...": {
                this.playSound("narrator_screen_title.wav");
                return;
            }
            case "You abandon the raid and leave the Tombs of Amascut.": {
                this.playSound("menu_savingLevel.wav");
                return;
            }
            case "Challenge started: The Wardens": {
                this.playSound("advancements_end_root_title.wav");
                return;
            }
            case "The statue has been struck! The seal weakens!": {
                this.playSound("advancements_story_mine_stone_title.wav");
                return;
            }
        }
        if (message.startsWith("Challenge complete: Path of Het. Duration:")) {
            this.playSound("advancements_story_upgrade_tools_title.wav");
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        String option;
        switch (option = Text.removeTags((String)(event.getMenuOption() + event.getMenuTarget()))) {
            case "Make Party": {
                this.playSound("selectWorld_create.wav");
                return;
            }
            case "ActivateTry Again": {
                this.playSound("options_difficulty_easy.wav");
                return;
            }
            case "ActivatePersistence": {
                this.playSound("options_difficulty_normal.wav");
                return;
            }
            case "ActivateSoftcore Run": {
                this.playSound("options_difficulty_hard.wav");
                return;
            }
            case "ActivateHardcore Run": {
                this.playSound("options_difficulty_hardcore.wav");
                return;
            }
            case "ViewApplicants": {
                this.playSound("menu_multiplayer.wav");
                return;
            }
            case "ViewInvocations": {
                this.playSound("menu_options.wav");
                return;
            }
            case "Logout": {
                this.playSound("menu_quit.wav");
                return;
            }
            case "InspectGrouping Obelisk": {
                this.playSound("deathScreen_titleScreen.wav");
                return;
            }
            case "EnterEntry": {
                this.playSound("selectWorld_enterName.wav");
                return;
            }
        }
    }
}

