/*
 * Decompiled with CFR 0.152.
 */
package com.aqpfinder;

import com.aqpfinder.AqpFinderConfig;
import com.aqpfinder.AqpFinderOverlay;
import com.aqpfinder.config.RecommendationMode;
import com.google.inject.Provides;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.FriendsChatMember;
import net.runelite.api.FriendsChatRank;
import net.runelite.api.MessageNode;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.Notifier;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Aqp Finder")
public class AqpFinderPlugin
extends Plugin
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(AqpFinderPlugin.class);
    @Inject
    private Client client;
    @Inject
    private AqpFinderConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private Notifier notifier;
    @Inject
    private KeyManager keyManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private AqpFinderOverlay overlay;
    private final String qp = "q p";
    private final int qpLength = 17;
    private final Map<Character, Integer> characterSizeMap = AqpFinderPlugin.createCharacterSizeMap();
    private final List<Character> endSentenceCharList = AqpFinderPlugin.createEndSentenceCharList();
    private boolean lastMessageIncludesQP = false;
    private boolean lastQPFromPM = false;
    private Integer[] lastMessageSegmentIndex = new Integer[0];
    private String chatBoxTypedText = "";
    private int chatBoxTypedTextLength = 0;
    private final List<String> overlayText = new ArrayList<String>();
    private final List<Integer> overlayTextColour = new ArrayList<Integer>();

    private static Map<Character, Integer> createCharacterSizeMap() {
        HashMap<Character, Integer> result = new HashMap<Character, Integer>();
        result.put(Character.valueOf('A'), 6);
        result.put(Character.valueOf('B'), 5);
        result.put(Character.valueOf('C'), 5);
        result.put(Character.valueOf('D'), 5);
        result.put(Character.valueOf('E'), 4);
        result.put(Character.valueOf('F'), 4);
        result.put(Character.valueOf('G'), 6);
        result.put(Character.valueOf('H'), 5);
        result.put(Character.valueOf('I'), 1);
        result.put(Character.valueOf('J'), 5);
        result.put(Character.valueOf('K'), 5);
        result.put(Character.valueOf('L'), 4);
        result.put(Character.valueOf('M'), 7);
        result.put(Character.valueOf('N'), 6);
        result.put(Character.valueOf('O'), 6);
        result.put(Character.valueOf('P'), 5);
        result.put(Character.valueOf('Q'), 6);
        result.put(Character.valueOf('R'), 5);
        result.put(Character.valueOf('S'), 5);
        result.put(Character.valueOf('T'), 3);
        result.put(Character.valueOf('U'), 6);
        result.put(Character.valueOf('V'), 5);
        result.put(Character.valueOf('W'), 7);
        result.put(Character.valueOf('X'), 5);
        result.put(Character.valueOf('Y'), 5);
        result.put(Character.valueOf('Z'), 5);
        result.put(Character.valueOf('a'), 5);
        result.put(Character.valueOf('b'), 5);
        result.put(Character.valueOf('c'), 4);
        result.put(Character.valueOf('d'), 5);
        result.put(Character.valueOf('e'), 5);
        result.put(Character.valueOf('f'), 4);
        result.put(Character.valueOf('g'), 5);
        result.put(Character.valueOf('h'), 5);
        result.put(Character.valueOf('i'), 1);
        result.put(Character.valueOf('j'), 4);
        result.put(Character.valueOf('k'), 4);
        result.put(Character.valueOf('l'), 1);
        result.put(Character.valueOf('m'), 7);
        result.put(Character.valueOf('n'), 5);
        result.put(Character.valueOf('o'), 5);
        result.put(Character.valueOf('p'), 5);
        result.put(Character.valueOf('q'), 5);
        result.put(Character.valueOf('r'), 3);
        result.put(Character.valueOf('s'), 5);
        result.put(Character.valueOf('t'), 3);
        result.put(Character.valueOf('u'), 5);
        result.put(Character.valueOf('v'), 5);
        result.put(Character.valueOf('w'), 5);
        result.put(Character.valueOf('x'), 5);
        result.put(Character.valueOf('y'), 5);
        result.put(Character.valueOf('z'), 5);
        result.put(Character.valueOf('0'), 6);
        result.put(Character.valueOf('1'), 4);
        result.put(Character.valueOf('2'), 6);
        result.put(Character.valueOf('3'), 5);
        result.put(Character.valueOf('4'), 5);
        result.put(Character.valueOf('5'), 5);
        result.put(Character.valueOf('6'), 6);
        result.put(Character.valueOf('7'), 5);
        result.put(Character.valueOf('8'), 6);
        result.put(Character.valueOf('9'), 6);
        result.put(Character.valueOf(' '), 1);
        result.put(Character.valueOf(':'), 1);
        result.put(Character.valueOf(';'), 2);
        result.put(Character.valueOf('\"'), 3);
        result.put(Character.valueOf('@'), 11);
        result.put(Character.valueOf('!'), 1);
        result.put(Character.valueOf('.'), 1);
        result.put(Character.valueOf('\''), 2);
        result.put(Character.valueOf(','), 2);
        result.put(Character.valueOf('('), 2);
        result.put(Character.valueOf(')'), 2);
        result.put(Character.valueOf('+'), 5);
        result.put(Character.valueOf('-'), 4);
        result.put(Character.valueOf('='), 6);
        result.put(Character.valueOf('?'), 6);
        result.put(Character.valueOf('*'), 7);
        result.put(Character.valueOf('/'), 4);
        result.put(Character.valueOf('$'), 6);
        result.put(Character.valueOf('\u00a3'), 8);
        result.put(Character.valueOf('^'), 6);
        result.put(Character.valueOf('{'), 3);
        result.put(Character.valueOf('}'), 3);
        result.put(Character.valueOf('['), 3);
        result.put(Character.valueOf(']'), 3);
        result.put(Character.valueOf('&'), 9);
        result.put(Character.valueOf('#'), 11);
        result.put(Character.valueOf('\u00a0'), 1);
        return Collections.unmodifiableMap(result);
    }

    private static List<Character> createEndSentenceCharList() {
        ArrayList<Character> result = new ArrayList<Character>();
        result.add(Character.valueOf('.'));
        result.add(Character.valueOf('!'));
        result.add(Character.valueOf('?'));
        return Collections.unmodifiableList(result);
    }

    protected void startUp() throws Exception {
        this.keyManager.registerKeyListener((KeyListener)this);
        if (this.config.showOverlay()) {
            this.overlayManager.add((Overlay)this.overlay);
        }
    }

    protected void shutDown() throws Exception {
        this.keyManager.unregisterKeyListener((KeyListener)this);
        if (this.config.showOverlay()) {
            this.overlayManager.remove((Overlay)this.overlay);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getKey().equals("showOverlay")) {
            if (this.config.showOverlay()) {
                this.overlayManager.add((Overlay)this.overlay);
                if (this.lastMessageIncludesQP) {
                    this.refreshChatBoxTypedText();
                    this.updateOverlayText();
                }
            } else {
                this.overlayManager.remove((Overlay)this.overlay);
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        MessageNode messageNode = chatMessage.getMessageNode();
        Object message = messageNode.getValue();
        boolean update = false;
        if (((String)message).contains("q p")) {
            int i;
            this.lastMessageIncludesQP = true;
            String originalMessage = message;
            message = ((String)message).substring(0, ((String)message).lastIndexOf("q p") + 3);
            String[] messageSegments = ((String)message).split("q p");
            List<Object> segmentLengths = Arrays.stream(messageSegments).map(this::getChatLength).collect(Collectors.toList());
            Integer[] segmentIndex = new Integer[segmentLengths.size()];
            int total = -17;
            if (messageNode.getType().equals((Object)ChatMessageType.PRIVATECHAT)) {
                segmentLengths.set(0, (Integer)segmentLengths.get(0) + 4 - 15);
                this.lastQPFromPM = true;
            } else if (messageNode.getType().equals((Object)ChatMessageType.PRIVATECHATOUT)) {
                segmentLengths.set(0, (Integer)segmentLengths.get(0) + 4);
                this.lastQPFromPM = true;
            } else {
                String sender = messageNode.getName();
                String localPlayer = this.client.getLocalPlayer().getName();
                int senderNameLength = this.getNameLength(sender);
                int localNameLength = this.getNameLength(localPlayer);
                if (messageNode.getType().equals((Object)ChatMessageType.FRIENDSCHAT)) {
                    senderNameLength += this.getFriendsChatRankIconSize(messageNode.getName());
                    localNameLength += this.getFriendsChatRankIconSize(this.client.getLocalPlayer().getName());
                }
                segmentLengths.set(0, (Integer)segmentLengths.get(0) + 4 + senderNameLength - localNameLength);
                this.lastQPFromPM = false;
            }
            if ((this.client.getAccountType().isIronman() || this.client.getAccountType().isGroupIronman() || this.config.hasIcon()) && !messageNode.getType().equals((Object)ChatMessageType.PRIVATECHATOUT)) {
                segmentLengths.set(0, (Integer)segmentLengths.get(0) - 13);
            }
            for (i = 0; i < segmentIndex.length; ++i) {
                segmentIndex[i] = total += (Integer)segmentLengths.get(i) + 17;
            }
            this.lastMessageSegmentIndex = Arrays.copyOf(segmentIndex, segmentIndex.length);
            for (i = 1; i < segmentLengths.size(); ++i) {
                segmentLengths.set(i, (Integer)segmentLengths.get(i) + 8);
            }
            if (this.config.showCumulative()) {
                segmentLengths = Arrays.asList(segmentIndex);
            } else {
                for (i = 0; i < segmentLengths.size() - 1; ++i) {
                    if (segmentIndex[i] >= 0) continue;
                    segmentLengths.set(i + 1, segmentIndex[i + 1]);
                    segmentLengths.set(i, -1);
                }
                if (segmentIndex[segmentIndex.length - 1] < 0) {
                    segmentLengths.set(segmentIndex.length - 1, -1);
                }
            }
            message = this.config.recommendationMode().equals((Object)RecommendationMode.SPACES) ? originalMessage + "   " + segmentLengths.stream().map(this::spacesToW).collect(Collectors.toList()) : originalMessage + "   " + segmentLengths;
            if (this.config.giveInlineHints()) {
                messageNode.setValue((String)message);
            }
            update = true;
        } else if (this.lastMessageIncludesQP) {
            this.lastMessageIncludesQP = false;
            this.lastMessageSegmentIndex = null;
        }
        if (this.lastMessageIncludesQP && this.config.showOverlay()) {
            this.refreshChatBoxTypedText();
            this.updateOverlayText();
        }
        if (update) {
            messageNode.setRuneLiteFormatMessage(messageNode.getValue());
            if (this.config.notifyOnQP()) {
                this.notifier.notify("A qp opportunity!");
            }
        }
    }

    private int getFriendsChatRankIconSize(String name) {
        int length = 0;
        try {
            FriendsChatRank rank = ((FriendsChatMember)this.client.getFriendsChatManager().findByName(name.replaceAll("<img=\\d+>", ""))).getRank();
            length = rank.equals((Object)FriendsChatRank.UNRANKED) ? 0 : 11;
        }
        catch (NullPointerException e) {
            log.warn("Caught NullPointerException when trying to find \"{}\"", (Object)name.replaceAll("<img=\\d+>", ""));
        }
        return length;
    }

    private int getChatLength(String chatMsg) {
        if (chatMsg == null) {
            return -5;
        }
        try {
            return chatMsg.chars().mapToObj(ch -> Character.valueOf((char)ch)).map(key -> this.characterSizeMap.get(key) + 2).reduce(0, (a, b) -> a + b);
        }
        catch (NullPointerException e) {
            return -5;
        }
    }

    private int getNameLength(String name) {
        if (name == null) {
            return -5;
        }
        return this.getChatLength(name.replaceAll("<img=\\d+>", "@"));
    }

    private String spacesToW(int pixels) {
        Object recommendation = "";
        if (pixels % 3 == 1) {
            pixels -= 4;
            recommendation = (String)recommendation + ", and ";
        }
        if (pixels % 3 == 2) {
            pixels -= 5;
            recommendation = (String)recommendation + "\" and ";
        }
        recommendation = pixels < 0 ? "impossible" : (String)recommendation + pixels / 3 + " spaces";
        return recommendation;
    }

    @Provides
    AqpFinderConfig provideConfig(ConfigManager configManager) {
        return (AqpFinderConfig)configManager.getConfig(AqpFinderConfig.class);
    }

    private String formatChatText(String chatText) {
        if (chatText == null) {
            return "";
        }
        char[] chatTextArray = chatText.toCharArray();
        boolean inWord = false;
        boolean newSentence = true;
        for (int i = 0; i < chatTextArray.length; ++i) {
            char ch = chatTextArray[i];
            if (Character.isLetter(ch)) {
                if (inWord) {
                    chatTextArray[i] = Character.toLowerCase(ch);
                }
                if (newSentence) {
                    chatTextArray[i] = Character.toUpperCase(ch);
                }
                inWord = true;
            } else {
                inWord = false;
            }
            if (this.endSentenceCharList.contains(Character.valueOf(ch))) {
                newSentence = true;
                continue;
            }
            if (Character.isWhitespace(ch)) continue;
            newSentence = false;
        }
        return new String(chatTextArray);
    }

    private void refreshChatBoxTypedText() {
        String newText = "";
        newText = this.lastQPFromPM ? this.client.getVarcStrValue(359) : this.client.getVarcStrValue(335);
        int controlCharacters = 0;
        if (newText.matches("/.*")) {
            controlCharacters = 1;
        }
        if (newText.matches("//.*|/p.*|/P.*|/f.*|/F.*|/c.*|/C.*|/g.*|/G.*")) {
            controlCharacters = 2;
        }
        if (newText.matches("/gc.*|/GC.*|/Gc.*|/gC.*")) {
            controlCharacters = 3;
        }
        newText = newText.substring(controlCharacters);
        if (!Objects.equals(newText = this.formatChatText(newText), this.chatBoxTypedText)) {
            this.chatBoxTypedText = newText;
            this.chatBoxTypedTextLength = this.getChatLength(this.chatBoxTypedText);
        }
    }

    private void updateOverlayText() {
        this.overlayText.clear();
        this.overlayTextColour.clear();
        for (Integer seg : this.lastMessageSegmentIndex) {
            int scaledPercentPixelsToW = seg < 0 ? 255 : Math.min(Math.round(Math.abs((float)((seg - this.chatBoxTypedTextLength) * 255) / (float)seg.intValue())), 255);
            String lineText = "error";
            if (seg - this.chatBoxTypedTextLength >= 3) {
                lineText = this.spacesToW(seg - this.chatBoxTypedTextLength);
            } else if (3 > seg - this.chatBoxTypedTextLength && seg - this.chatBoxTypedTextLength > 0) {
                lineText = "Too close.";
            } else if (seg == this.chatBoxTypedTextLength) {
                lineText = "Hit W now!";
            } else if (seg - this.chatBoxTypedTextLength < 0) {
                lineText = "Too far.";
            }
            this.overlayText.add(lineText);
            this.overlayTextColour.add(scaledPercentPixelsToW);
        }
    }

    private void checkChatBoxUpdateOverlay() {
        if (this.lastMessageIncludesQP && this.config.showOverlay()) {
            this.refreshChatBoxTypedText();
            this.updateOverlayText();
        }
    }

    public void keyTyped(KeyEvent e) {
        this.checkChatBoxUpdateOverlay();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.checkChatBoxUpdateOverlay();
    }

    public boolean isLastMessageIncludesQP() {
        return this.lastMessageIncludesQP;
    }

    public List<String> getOverlayText() {
        return this.overlayText;
    }

    public List<Integer> getOverlayTextColour() {
        return this.overlayTextColour;
    }
}

