/*
 * Decompiled with CFR 0.152.
 */
package com.aqpfinder;

import com.aqpfinder.AqpFinderPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.List;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class AqpFinderOverlay
extends OverlayPanel {
    private final AqpFinderPlugin plugin;

    @Inject
    private AqpFinderOverlay(AqpFinderPlugin plugin) {
        this.plugin = plugin;
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isLastMessageIncludesQP()) {
            return null;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int panelWidth = Math.max(129, fontMetrics.stringWidth("A q p target sighted!") + 4 + 4);
        this.panelComponent.setPreferredSize(new Dimension(panelWidth, 0));
        this.panelComponent.getChildren().add(TitleComponent.builder().text("A q p target sighted!").build());
        List<String> overlayText = this.plugin.getOverlayText();
        List<Integer> overlayTextColour = this.plugin.getOverlayTextColour();
        for (int i = 0; i < overlayText.size(); ++i) {
            String lineText = overlayText.get(i);
            Integer redColourValue = overlayTextColour.get(i);
            this.panelComponent.getChildren().add(LineComponent.builder().left(lineText).leftColor(new Color(redColourValue, 255 - redColourValue, 0)).build());
        }
        return super.render(graphics);
    }
}

