/*
 * Decompiled with CFR 0.152.
 */
package com.betterdiscordlootlogger;

import com.betterdiscordlootlogger.BetterDiscordLootLoggerConfig;
import com.betterdiscordlootlogger.DiscordWebhookBody;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.UsernameChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.util.HotkeyListener;
import net.runelite.client.util.Text;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Better Discord Loot Logger")
public class BetterDiscordLootLoggerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BetterDiscordLootLoggerPlugin.class);
    private static final String COLLECTION_LOG_TEXT = "New item added to your collection log: ";
    private static final Pattern VALUABLE_DROP_PATTERN = Pattern.compile(".*Valuable drop: ([^<>]+?\\(((?:\\d+,?)+) coins\\))(?:</col>)?");
    private static final ImmutableList<String> PET_MESSAGES = ImmutableList.of((Object)"You have a funny feeling like you're being followed", (Object)"You feel something weird sneaking into your backpack", (Object)"You have a funny feeling like you would have been followed");
    private static final Pattern COX_UNIQUE_MESSAGE_PATTERN = Pattern.compile("(.+) - (.+)");
    private static final String COX_DUST_MESSAGE_TEXT = "Dust recipients: ";
    private static final String COX_KIT_MESSAGE_TEXT = "Twisted Kit recipients: ";
    private static final Pattern TOB_UNIQUE_MESSAGE_PATTERN = Pattern.compile("(.+) found something special: (.+)");
    private static final Pattern KC_MESSAGE_PATTERN = Pattern.compile("([0-9]+)");
    private boolean shouldSendMessage;
    private boolean notificationStarted;
    private RaidType raidType;
    private Integer raidKc;
    private String raidItemName;
    @Inject
    private Client client;
    @Inject
    private BetterDiscordLootLoggerConfig config;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private KeyManager keyManager;
    @Inject
    private DrawManager drawManager;
    private final HotkeyListener hotkeyListener = new HotkeyListener(() -> this.config.keybind()){

        public void hotkeyPressed() {
            BetterDiscordLootLoggerPlugin.this.sendMessage("", 0, "", "", "manual");
        }
    };

    protected void startUp() throws Exception {
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener);
    }

    protected void shutDown() throws Exception {
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener);
        this.notificationStarted = false;
    }

    @Subscribe
    public void onUsernameChanged(UsernameChanged usernameChanged) {
        this.resetState();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState().equals((Object)GameState.LOGIN_SCREEN)) {
            this.resetState();
        } else {
            this.shouldSendMessage = true;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        int valuableDropValue;
        Matcher matcher;
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM && event.getType() != ChatMessageType.TRADE && event.getType() != ChatMessageType.FRIENDSCHATNOTIFICATION) {
            return;
        }
        String chatMessage = event.getMessage();
        if (this.config.includePets()) {
            if (PET_MESSAGES.stream().anyMatch(chatMessage::contains)) {
                this.sendMessage("", 0, "", "", "pet");
            }
        }
        if (this.config.includeValuableDrops() && (matcher = VALUABLE_DROP_PATTERN.matcher(chatMessage)).matches() && (valuableDropValue = Integer.parseInt(matcher.group(2).replaceAll(",", ""))) >= this.config.valuableDropThreshold()) {
            String[] valuableDrop = matcher.group(1).split(" \\(");
            String valuableDropName = (String)Array.get(valuableDrop, 0);
            String valuableDropValueString = matcher.group(2);
            this.sendMessage(valuableDropName, 0, "", valuableDropValueString, "valuable drop");
        }
        if (this.config.includeCollectionLogItems() && chatMessage.startsWith(COLLECTION_LOG_TEXT) && this.client.getVarbitValue(11959) == 1) {
            String entry = Text.removeTags((String)chatMessage).substring(COLLECTION_LOG_TEXT.length());
            this.sendMessage(entry, 0, "", "", "collection log");
        }
        if (this.config.includeRaidLoot()) {
            Matcher tobUniqueMessage;
            String dropName;
            if (chatMessage.startsWith("Your completed Chambers of Xeric count is:") && (matcher = KC_MESSAGE_PATTERN.matcher(Text.removeTags((String)chatMessage))).find()) {
                this.raidType = chatMessage.contains("Challenge Mode") ? RaidType.COX_CM : RaidType.COX;
                this.raidKc = Integer.valueOf(matcher.group());
                return;
            }
            if (chatMessage.startsWith("Your completed Theatre of Blood") && (matcher = KC_MESSAGE_PATTERN.matcher(Text.removeTags((String)chatMessage))).find()) {
                this.raidType = chatMessage.contains("Hard Mode") ? RaidType.TOB_HM : (chatMessage.contains("Story Mode") ? RaidType.TOB_SM : RaidType.TOB);
                this.raidKc = Integer.valueOf(matcher.group());
                return;
            }
            Matcher uniqueMessage = COX_UNIQUE_MESSAGE_PATTERN.matcher(chatMessage);
            if (uniqueMessage.matches()) {
                String lootRecipient = Text.sanitize((String)uniqueMessage.group(1)).trim();
                dropName = uniqueMessage.group(2).trim();
                if (lootRecipient.equals(Text.sanitize((String)Objects.requireNonNull(this.client.getLocalPlayer().getName())))) {
                    this.raidItemName = dropName;
                    this.sendMessage(this.raidItemName, this.raidKc, "Theatre of Blood", "", "raid loot");
                }
            }
            if (chatMessage.startsWith(COX_DUST_MESSAGE_TEXT)) {
                String dustRecipient = Text.removeTags((String)chatMessage).substring(COX_DUST_MESSAGE_TEXT.length());
                dropName = "Metamorphic dust";
                if (dustRecipient.equals(Text.sanitize((String)Objects.requireNonNull(this.client.getLocalPlayer().getName())))) {
                    this.raidItemName = "Metamorphic dust";
                }
            }
            if (chatMessage.startsWith(COX_KIT_MESSAGE_TEXT)) {
                String dustRecipient = Text.removeTags((String)chatMessage).substring(COX_KIT_MESSAGE_TEXT.length());
                dropName = "Twisted ancestral colour kit";
                if (dustRecipient.equals(Text.sanitize((String)Objects.requireNonNull(this.client.getLocalPlayer().getName())))) {
                    this.raidItemName = "Twisted ancestral colour kit";
                }
            }
            if ((tobUniqueMessage = TOB_UNIQUE_MESSAGE_PATTERN.matcher(chatMessage)).matches()) {
                String lootRecipient = Text.sanitize((String)tobUniqueMessage.group(1)).trim();
                String dropName2 = tobUniqueMessage.group(2).trim();
                if (lootRecipient.equals(Text.sanitize((String)Objects.requireNonNull(this.client.getLocalPlayer().getName())))) {
                    this.raidItemName = dropName2;
                }
            }
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        int groupId = event.getGroupId();
        if (groupId == 539 || groupId == 23) {
            if (!this.config.includeRaidLoot()) {
                return;
            }
            if (groupId == 539 && this.raidItemName != null) {
                if (this.raidType == RaidType.COX) {
                    this.sendMessage(this.raidItemName, this.raidKc, "Chambers of Xeric", "", "raid loot");
                } else if (this.raidType == RaidType.COX_CM) {
                    this.sendMessage(this.raidItemName, this.raidKc, "Chambers of Xeric Challenge Mode", "", "raid loot");
                }
                return;
            }
            if (groupId == 23 && this.raidItemName != null) {
                if (this.raidType != RaidType.TOB && this.raidType != RaidType.TOB_SM && this.raidType != RaidType.TOB_HM) {
                    return;
                }
                switch (this.raidType) {
                    case TOB: {
                        this.sendMessage(this.raidItemName, this.raidKc, "Theatre of Blood", "", "raid loot");
                        break;
                    }
                    case TOB_SM: {
                        this.sendMessage(this.raidItemName, this.raidKc, "Theatre of Blood Story mode", "", "raid loot");
                        break;
                    }
                    case TOB_HM: {
                        this.sendMessage(this.raidItemName, this.raidKc, "Theatre of Blood Hard Mode", "", "raid loot");
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            this.raidItemName = null;
            this.raidType = null;
            this.raidKc = 0;
        }
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        switch (scriptPreFired.getScriptId()) {
            case 3346: {
                this.notificationStarted = true;
                break;
            }
            case 3347: {
                if (!this.notificationStarted) {
                    return;
                }
                String notificationTopText = this.client.getVarcStrValue(387);
                String notificationBottomText = this.client.getVarcStrValue(388);
                if (notificationTopText.equalsIgnoreCase("Collection log") && this.config.includeCollectionLogItems()) {
                    String entry = Text.removeTags((String)notificationBottomText).substring("New item:".length());
                    this.sendMessage(entry, 0, "", "", "collection log");
                }
                this.notificationStarted = false;
            }
        }
    }

    @Provides
    BetterDiscordLootLoggerConfig provideConfig(ConfigManager configManager) {
        return (BetterDiscordLootLoggerConfig)configManager.getConfig(BetterDiscordLootLoggerConfig.class);
    }

    private void sendMessage(String itemName, Integer itemKc, String bossName, String itemValue, String notificationType) {
        if (!this.shouldSendMessage) {
            return;
        }
        switch (notificationType) {
            case "pet": {
                itemName = " a new pet!";
                break;
            }
            case "valuable drop": {
                itemName = " a valuable drop: **" + (String)itemName + "**!";
                break;
            }
            case "collection log": {
                itemName = " a new collection log item: **" + (String)itemName + "**!";
                break;
            }
            case "raid loot": {
                itemName = " a rare drop from " + bossName + ": **" + (String)itemName + "**!" + (String)(itemKc == null ? "" : (itemKc == 0 ? "" : "\nKill Count: **" + itemKc + "**"));
                break;
            }
            default: {
                itemName = " **a rare drop**";
            }
        }
        String screenshotString = "**" + this.client.getLocalPlayer().getName() + "**";
        screenshotString = !itemValue.isEmpty() ? screenshotString + " just received" + (String)itemName + "\nApprox Value: **" + itemValue + " coins**" : screenshotString + " just received" + (String)itemName;
        DiscordWebhookBody discordWebhookBody = new DiscordWebhookBody();
        discordWebhookBody.setContent(screenshotString);
        this.sendWebhook(discordWebhookBody);
    }

    private void sendWebhook(DiscordWebhookBody discordWebhookBody) {
        String configUrl = this.config.webhook();
        if (Strings.isNullOrEmpty((String)configUrl)) {
            return;
        }
        ArrayList<String> urls = new ArrayList<String>(Arrays.asList(configUrl.split("\\s*,\\s*")));
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", RuneLiteAPI.GSON.toJson((Object)discordWebhookBody));
        for (String url : urls) {
            HttpUrl httpUrl = HttpUrl.parse((String)url);
            if (httpUrl == null) continue;
            if (this.config.sendScreenshot()) {
                this.sendWebhookWithScreenshot(httpUrl, requestBodyBuilder);
                continue;
            }
            this.buildRequestAndSend(httpUrl, requestBodyBuilder);
        }
    }

    private void sendWebhookWithScreenshot(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        this.drawManager.requestNextFrameListener(image -> {
            byte[] imageBytes;
            BufferedImage bufferedImage = (BufferedImage)image;
            try {
                imageBytes = BetterDiscordLootLoggerPlugin.convertImageToByteArray(bufferedImage);
            }
            catch (IOException e) {
                log.warn("Error converting image to byte array", (Throwable)e);
                return;
            }
            requestBodyBuilder.addFormDataPart("file", "image.png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])imageBytes));
            this.buildRequestAndSend(url, requestBodyBuilder);
        });
    }

    private void buildRequestAndSend(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        this.sendRequest(request);
    }

    private void sendRequest(Request request) {
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Error submitting webhook", (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                response.close();
            }
        });
    }

    private static byte[] convertImageToByteArray(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void resetState() {
        this.shouldSendMessage = false;
    }

    private boolean isInCox() {
        return this.client.getGameState() == GameState.LOGGED_IN && this.client.getVarbitValue(5432) == 1;
    }

    private boolean isInTob() {
        return this.client.getGameState() == GameState.LOGGED_IN && this.client.getVarbitValue(6440) == 2;
    }

    static enum RaidType {
        COX,
        COX_CM,
        TOB,
        TOB_SM,
        TOB_HM;

    }
}

