/*
 * Decompiled with CFR 0.152.
 */
package com.pcrewards;

import com.google.inject.Provides;
import com.pcrewards.PcRewardsConfig;
import com.pcrewards.PcRewardsDrawWidget;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="PC Rewards", description="Customize the PC Rewards screen to prevent unwanted spending", tags={"pest control", "pc", "minigame", "hide", "points"})
public class PcRewardsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PcRewardsPlugin.class);
    public static final int PC_SHOP_WIDGET_ID = 0xF30003;
    public static final int PC_SHOP_GROUP_ID = 243;
    public static final int PC_POINTS_WIDGET_ID = 15925256;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private PcRewardsConfig config;
    @Inject
    private PcRewardsDrawWidget drawPcWidget;

    protected void startUp() throws Exception {
        Widget points_Screen = this.client.getWidget(0xF30003);
        if (points_Screen == null) {
            return;
        }
        this.clientThread.invokeAtTickEnd(() -> {
            this.drawPcWidget.draw_Widget(this.get_Pest_Points());
            this.hideOptions();
        });
    }

    protected void shutDown() throws Exception {
        this.unhide_ALL();
        this.drawPcWidget.delete_Widget();
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        this.hideOptions();
        this.drawPcWidget.update_Calculation();
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        Widget pc_shop_interface = menuOptionClicked.getWidget();
        if (pc_shop_interface == null) {
            return;
        }
        if (pc_shop_interface.getId() == 0xF30003) {
            this.clientThread.invokeAtTickEnd(() -> this.hideOptions());
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (widgetLoaded.getGroupId() == 243) {
            this.clientThread.invokeAtTickEnd(() -> {
                this.drawPcWidget.draw_Widget(this.get_Pest_Points());
                this.hideOptions();
            });
        }
    }

    private void hideOptions() {
        Widget points_Screen = this.client.getWidget(0xF30003);
        if (points_Screen == null) {
            return;
        }
        Widget[] rewards = points_Screen.getDynamicChildren();
        int total_points = this.get_Pest_Points();
        switch (this.config.getAtkOp()) {
            case ALL: {
                rewards[2].setHidden(false);
                rewards[3].setHidden(false);
                rewards[4].setHidden(false);
                break;
            }
            case NONE: {
                rewards[2].setHidden(true);
                rewards[3].setHidden(true);
                rewards[4].setHidden(true);
                break;
            }
            case ONLY_100: {
                rewards[2].setHidden(true);
                rewards[3].setHidden(true);
                rewards[4].setHidden(false);
                break;
            }
            case GREATER_THAN_100: {
                if (total_points < 100) {
                    rewards[2].setHidden(false);
                    rewards[3].setHidden(false);
                    rewards[4].setHidden(false);
                    break;
                }
                rewards[2].setHidden(true);
                rewards[3].setHidden(true);
                rewards[4].setHidden(false);
            }
        }
        switch (this.config.getStrOp()) {
            case ALL: {
                rewards[7].setHidden(false);
                rewards[8].setHidden(false);
                rewards[9].setHidden(false);
                break;
            }
            case NONE: {
                rewards[7].setHidden(true);
                rewards[8].setHidden(true);
                rewards[9].setHidden(true);
                break;
            }
            case ONLY_100: {
                rewards[7].setHidden(true);
                rewards[8].setHidden(true);
                rewards[9].setHidden(false);
                break;
            }
            case GREATER_THAN_100: {
                if (total_points < 100) {
                    rewards[7].setHidden(false);
                    rewards[8].setHidden(false);
                    rewards[9].setHidden(false);
                    break;
                }
                rewards[7].setHidden(true);
                rewards[8].setHidden(true);
                rewards[9].setHidden(false);
            }
        }
        switch (this.config.getDefOp()) {
            case ALL: {
                rewards[12].setHidden(false);
                rewards[13].setHidden(false);
                rewards[14].setHidden(false);
                break;
            }
            case NONE: {
                rewards[12].setHidden(true);
                rewards[13].setHidden(true);
                rewards[14].setHidden(true);
                break;
            }
            case ONLY_100: {
                rewards[12].setHidden(true);
                rewards[13].setHidden(true);
                rewards[14].setHidden(false);
                break;
            }
            case GREATER_THAN_100: {
                if (total_points < 100) {
                    rewards[12].setHidden(false);
                    rewards[13].setHidden(false);
                    rewards[14].setHidden(false);
                    break;
                }
                rewards[12].setHidden(true);
                rewards[13].setHidden(true);
                rewards[14].setHidden(false);
            }
        }
        switch (this.config.getRngOp()) {
            case ALL: {
                rewards[17].setHidden(false);
                rewards[18].setHidden(false);
                rewards[19].setHidden(false);
                break;
            }
            case NONE: {
                rewards[17].setHidden(true);
                rewards[18].setHidden(true);
                rewards[19].setHidden(true);
                break;
            }
            case ONLY_100: {
                rewards[17].setHidden(true);
                rewards[18].setHidden(true);
                rewards[19].setHidden(false);
                break;
            }
            case GREATER_THAN_100: {
                if (total_points < 100) {
                    rewards[17].setHidden(false);
                    rewards[18].setHidden(false);
                    rewards[19].setHidden(false);
                    break;
                }
                rewards[17].setHidden(true);
                rewards[18].setHidden(true);
                rewards[19].setHidden(false);
            }
        }
        switch (this.config.getMagicOp()) {
            case ALL: {
                rewards[22].setHidden(false);
                rewards[23].setHidden(false);
                rewards[24].setHidden(false);
                break;
            }
            case NONE: {
                rewards[22].setHidden(true);
                rewards[23].setHidden(true);
                rewards[24].setHidden(true);
                break;
            }
            case ONLY_100: {
                rewards[22].setHidden(true);
                rewards[23].setHidden(true);
                rewards[24].setHidden(false);
                break;
            }
            case GREATER_THAN_100: {
                if (total_points < 100) {
                    rewards[22].setHidden(false);
                    rewards[23].setHidden(false);
                    rewards[24].setHidden(false);
                    break;
                }
                rewards[22].setHidden(true);
                rewards[23].setHidden(true);
                rewards[24].setHidden(false);
            }
        }
        switch (this.config.getHpOp()) {
            case ALL: {
                rewards[27].setHidden(false);
                rewards[28].setHidden(false);
                rewards[29].setHidden(false);
                break;
            }
            case NONE: {
                rewards[27].setHidden(true);
                rewards[28].setHidden(true);
                rewards[29].setHidden(true);
                break;
            }
            case ONLY_100: {
                rewards[27].setHidden(true);
                rewards[28].setHidden(true);
                rewards[29].setHidden(false);
                break;
            }
            case GREATER_THAN_100: {
                if (total_points < 100) {
                    rewards[27].setHidden(false);
                    rewards[28].setHidden(false);
                    rewards[29].setHidden(false);
                    break;
                }
                rewards[27].setHidden(true);
                rewards[28].setHidden(true);
                rewards[29].setHidden(false);
            }
        }
        switch (this.config.getPrayOp()) {
            case ALL: {
                rewards[32].setHidden(false);
                rewards[33].setHidden(false);
                rewards[34].setHidden(false);
                break;
            }
            case NONE: {
                rewards[32].setHidden(true);
                rewards[33].setHidden(true);
                rewards[34].setHidden(true);
                break;
            }
            case ONLY_100: {
                rewards[32].setHidden(true);
                rewards[33].setHidden(true);
                rewards[34].setHidden(false);
                break;
            }
            case GREATER_THAN_100: {
                if (total_points < 100) {
                    rewards[32].setHidden(false);
                    rewards[33].setHidden(false);
                    rewards[34].setHidden(false);
                    break;
                }
                rewards[32].setHidden(true);
                rewards[33].setHidden(true);
                rewards[34].setHidden(false);
            }
        }
        rewards[37].setHidden(this.config.getHerb());
        rewards[40].setHidden(this.config.getHerb());
        rewards[41].setHidden(this.config.getMine());
        rewards[44].setHidden(this.config.getMine());
        rewards[45].setHidden(this.config.getSeed());
        rewards[48].setHidden(this.config.getSeed());
        rewards[51].setHidden(this.config.getMace());
        rewards[54].setHidden(this.config.getMace());
        rewards[55].setHidden(this.config.getRTop());
        rewards[58].setHidden(this.config.getRTop());
        rewards[59].setHidden(this.config.getRBtm());
        rewards[62].setHidden(this.config.getRBtm());
        rewards[63].setHidden(this.config.getGlove());
        rewards[66].setHidden(this.config.getGlove());
        rewards[67].setHidden(this.config.getMageHelm());
        rewards[70].setHidden(this.config.getMageHelm());
        rewards[71].setHidden(this.config.getRhelm());
        rewards[74].setHidden(this.config.getRhelm());
        rewards[75].setHidden(this.config.getMelHelm());
        rewards[78].setHidden(this.config.getMelHelm());
        rewards[79].setHidden(this.config.getSeal());
        rewards[82].setHidden(this.config.getSeal());
    }

    private void unhide_ALL() {
        Widget points_Screen = this.client.getWidget(0xF30003);
        if (points_Screen == null) {
            return;
        }
        Widget[] rewards = points_Screen.getDynamicChildren();
        for (int i = 0; i < rewards.length; ++i) {
            if (!rewards[i].isSelfHidden()) continue;
            rewards[i].setHidden(false);
        }
    }

    private int get_Pest_Points() {
        Widget points_loc = this.client.getWidget(15925256);
        String points_text = points_loc.getText();
        String value_points = points_text.substring(points_text.indexOf(">") + 1, points_text.lastIndexOf("<"));
        String fixed_points = value_points.replace(",", "");
        return Integer.parseInt(fixed_points);
    }

    @Provides
    PcRewardsConfig provideConfig(ConfigManager configManager) {
        return (PcRewardsConfig)configManager.getConfig(PcRewardsConfig.class);
    }
}

