/*
 * Decompiled with CFR 0.152.
 */
package com.pcrewards;

import com.pcrewards.PcMath;
import com.pcrewards.PcRewardExpOptions;
import com.pcrewards.PcRewardsConfig;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.widgets.Widget;

public class PcRewardsDrawWidget {
    private static final int PC_REWARDS_BAR_WIDGET = 15925253;
    public static final int font_ID = 496;
    public static final int font_Color = 16750623;
    @Inject
    private PcRewardsConfig config;
    @Inject
    private Client client;
    private Widget parent_Widget = null;
    private Widget drawn_Widget = null;
    private int saved_points = -1;

    public void draw_Widget(int pest_points) {
        this.saved_points = pest_points;
        this.parent_Widget = this.client.getWidget(15925253);
        if (this.parent_Widget == null) {
            return;
        }
        this.drawn_Widget = this.parent_Widget.createChild(0, 4);
        this.drawn_Widget.setFontId(496);
        this.drawn_Widget.setOpacity(0);
        if (this.config.getCalcStyle() == PcRewardExpOptions.HIDE) {
            this.drawn_Widget.setHidden(true);
        } else {
            this.drawn_Widget.setHidden(false);
        }
        this.drawn_Widget.setTextColor(16750623);
        this.drawn_Widget.setTextShadowed(true);
        String points_String = this.config.getCalcStyle().toString() + " Exp: <col=ffffff>" + String.format("%,d", PcMath.calc_Reward_EXP(this.get_Level(this.config.getCalcStyle()), pest_points, this.config.getCalcStyle(), this.config.getExpMult())) + "</col";
        this.drawn_Widget.setText(points_String);
        this.drawn_Widget.setOriginalHeight(40);
        this.drawn_Widget.setOriginalWidth(140);
        this.drawn_Widget.setOriginalX(320);
        this.drawn_Widget.setOriginalY(-3);
        this.drawn_Widget.setLineHeight(15);
        this.drawn_Widget.setXTextAlignment(1);
        this.drawn_Widget.setYTextAlignment(1);
        this.drawn_Widget.revalidate();
    }

    public void update_Calculation() {
        if (this.drawn_Widget == null) {
            return;
        }
        if (this.config.getCalcStyle() == PcRewardExpOptions.HIDE) {
            this.drawn_Widget.setHidden(true);
        } else {
            this.drawn_Widget.setHidden(false);
        }
        String points_String = this.config.getCalcStyle().toString() + " Exp: <col=ffffff>" + String.format("%,d", PcMath.calc_Reward_EXP(this.get_Level(this.config.getCalcStyle()), this.saved_points, this.config.getCalcStyle(), this.config.getExpMult())) + "</col";
        this.drawn_Widget.setText(points_String);
    }

    public void delete_Widget() {
        if (this.parent_Widget == null) {
            return;
        }
        this.parent_Widget.deleteAllChildren();
    }

    private int get_Level(PcRewardExpOptions pcRewardExpOptions) {
        int level = 0;
        switch (pcRewardExpOptions) {
            case ATTACK: {
                level = this.client.getRealSkillLevel(Skill.ATTACK);
                break;
            }
            case STRENGTH: {
                level = this.client.getRealSkillLevel(Skill.STRENGTH);
                break;
            }
            case DEFENCE: {
                level = this.client.getRealSkillLevel(Skill.DEFENCE);
                break;
            }
            case HITPOINTS: {
                level = this.client.getRealSkillLevel(Skill.HITPOINTS);
                break;
            }
            case MAGIC: {
                level = this.client.getRealSkillLevel(Skill.MAGIC);
                break;
            }
            case RANGE: {
                level = this.client.getRealSkillLevel(Skill.RANGED);
                break;
            }
            case PRAYER: {
                level = this.client.getRealSkillLevel(Skill.PRAYER);
                break;
            }
            case HIDE: {
                level = 0;
            }
        }
        return level;
    }
}

