/*
 * Decompiled with CFR 0.152.
 */
package com.inventorycost;

import com.inventorycost.InventoryCostConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class InventoryCostOverlay
extends OverlayPanel {
    private static final int PANEL_WIDTH_OFFSET = 10;
    private int SAVED_COST;
    private final Client client;
    private final InventoryCostConfig config;
    private final ItemManager itemManager;

    @Inject
    private InventoryCostOverlay(Client client, InventoryCostConfig config, ItemManager itemManager) {
        this.client = client;
        this.config = config;
        this.itemManager = itemManager;
        this.SAVED_COST = 0;
    }

    public Dimension render(Graphics2D graphics) {
        String title = "Inventory Cost";
        this.panelComponent.getChildren().add(TitleComponent.builder().text("Inventory Cost").build());
        int maxWidth = 129;
        this.panelComponent.getChildren().add(LineComponent.builder().left("CURRENT").right(this.formatCostText(this.calculateTotalCost())).build());
        if (this.config.saveCost()) {
            if (this.SAVED_COST >= 0) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("SAVED").right(this.formatCostText(this.SAVED_COST)).build());
                this.panelComponent.getChildren().add(LineComponent.builder().left("").right("").build());
                this.panelComponent.getChildren().add(LineComponent.builder().left("DIFF").right(this.setDifferenceCostText()).rightColor(this.setDifferenceCostColor()).build());
                this.panelComponent.setPreferredSize(new Dimension(maxWidth + 10, 0));
            } else {
                this.saveCost();
            }
        } else {
            this.SAVED_COST = -1;
        }
        return super.render(graphics);
    }

    private int calculateTotalCost() {
        int totalCost = 0;
        totalCost += this.calculateItemsCost(this.client.getItemContainer(InventoryID.INVENTORY));
        if (!this.config.excludeHeadEquipmentCost()) {
            totalCost += this.calculateEquipmentSlotCost(EquipmentInventorySlot.HEAD.getSlotIdx());
        }
        if (!this.config.excludeBodyEquipmentCost()) {
            totalCost += this.calculateEquipmentSlotCost(EquipmentInventorySlot.BODY.getSlotIdx());
        }
        if (!this.config.excludeCapeEquipmentCost()) {
            totalCost += this.calculateEquipmentSlotCost(EquipmentInventorySlot.CAPE.getSlotIdx());
        }
        if (!this.config.excludeAmuletEquipmentCost()) {
            totalCost += this.calculateEquipmentSlotCost(EquipmentInventorySlot.AMULET.getSlotIdx());
        }
        if (!this.config.excludeGlovesEquipmentCost()) {
            totalCost += this.calculateEquipmentSlotCost(EquipmentInventorySlot.GLOVES.getSlotIdx());
        }
        if (!this.config.excludeWeaponEquipmentCost()) {
            totalCost += this.calculateEquipmentSlotCost(EquipmentInventorySlot.WEAPON.getSlotIdx());
        }
        if (!this.config.excludeShieldEquipmentCost()) {
            totalCost += this.calculateEquipmentSlotCost(EquipmentInventorySlot.SHIELD.getSlotIdx());
        }
        if (!this.config.excludeRingEquipmentCost()) {
            totalCost += this.calculateEquipmentSlotCost(EquipmentInventorySlot.RING.getSlotIdx());
        }
        if (!this.config.excludeAmmoEquipmentCost()) {
            totalCost += this.calculateEquipmentSlotCost(EquipmentInventorySlot.AMMO.getSlotIdx());
        }
        if (!this.config.excludeLegsEquipmentCost()) {
            totalCost += this.calculateEquipmentSlotCost(EquipmentInventorySlot.LEGS.getSlotIdx());
        }
        if (!this.config.excludeBootsEquipmentCost()) {
            totalCost += this.calculateEquipmentSlotCost(EquipmentInventorySlot.BOOTS.getSlotIdx());
        }
        return totalCost;
    }

    private int calculateItemsCost(ItemContainer itemContainer) {
        if (itemContainer == null) {
            return 0;
        }
        Item[] items = itemContainer.getItems();
        if (items == null) {
            return 0;
        }
        int totalCost = 0;
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            int itemPrice = this.getItemPrice(item.getId());
            if (item.getQuantity() > 0) {
                totalCost += itemPrice * item.getQuantity();
                continue;
            }
            totalCost += itemPrice;
        }
        return totalCost;
    }

    private int calculateEquipmentSlotCost(int index) {
        Item[] items = this.client.getItemContainer(InventoryID.EQUIPMENT).getItems();
        if (items == null) {
            return 0;
        }
        Item slotItem = items[index];
        if (slotItem == null) {
            return 0;
        }
        if (slotItem.getQuantity() > 0) {
            return this.getItemPrice(slotItem.getId()) * slotItem.getQuantity();
        }
        return this.getItemPrice(slotItem.getId());
    }

    private int calculateSaveCostDifference() {
        return this.calculateTotalCost() - this.SAVED_COST;
    }

    private void saveCost() {
        this.SAVED_COST = this.calculateTotalCost();
    }

    private int getItemPrice(int id) {
        return this.itemManager.getItemPrice(id);
    }

    private String setDifferenceCostText() {
        if (this.SAVED_COST < this.calculateTotalCost()) {
            return "+" + this.formatCostText(this.calculateSaveCostDifference());
        }
        return this.formatCostText(this.calculateSaveCostDifference());
    }

    private Color setDifferenceCostColor() {
        if (this.SAVED_COST > this.calculateTotalCost()) {
            return Color.RED;
        }
        if (this.SAVED_COST < this.calculateTotalCost()) {
            return Color.GREEN;
        }
        return Color.WHITE;
    }

    private String formatCostText(int value) {
        Double numParsed = Double.parseDouble(Integer.toString(value));
        return String.format("%,.0f", numParsed);
    }
}

