/*
 * Decompiled with CFR 0.152.
 */
package com.rymr.npcaccessibilitytagger;

import com.google.inject.Provides;
import com.rymr.npcaccessibilitytagger.NpcAccessibilityTaggerConfig;
import com.rymr.npcaccessibilitytagger.NpcAccessibilityTaggerOverlay;
import com.rymr.npcaccessibilitytagger.NpcAccessibilityTaggerParser;
import javax.inject.Inject;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="NPC Accessibility Tagger", description="Tags NPCs with text for easier visual identification, aimed at helping people with accessibility issues", tags={"npcs", "accessibility", "tagger", "overlay", "tags"})
public class NpcAccessibilityTaggerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NpcAccessibilityTaggerPlugin.class);
    @Inject
    private NpcAccessibilityTaggerConfig config;
    @Inject
    private NpcAccessibilityTaggerOverlay overlay;
    @Inject
    private OverlayManager overlayManager;

    protected void startUp() throws Exception {
        log.info("Started plugin");
        this.updateAddition();
    }

    protected void shutDown() throws Exception {
        log.info("Shutdown plugin");
        this.updateRemoval();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("npcaccessibilitytagger")) {
            return;
        }
        this.update();
    }

    private void update() {
        this.updateRemoval();
        this.updateAddition();
    }

    private void updateRemoval() {
        NpcAccessibilityTaggerParser.getInstance().getEntries().clear();
        this.overlayManager.remove((Overlay)this.overlay);
    }

    private void updateAddition() {
        NpcAccessibilityTaggerParser.getInstance().parse(this.config);
        this.overlayManager.add((Overlay)this.overlay);
    }

    @Provides
    NpcAccessibilityTaggerConfig provideConfig(ConfigManager configManager) {
        return (NpcAccessibilityTaggerConfig)configManager.getConfig(NpcAccessibilityTaggerConfig.class);
    }
}

