/*
 * Decompiled with CFR 0.152.
 */
package com.rymr.npcaccessibilitytagger;

import com.rymr.npcaccessibilitytagger.ExtendedEntry;
import com.rymr.npcaccessibilitytagger.NpcAccessibilityTaggerConfig;
import com.rymr.npcaccessibilitytagger.StandardEntry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpcAccessibilityTaggerParser {
    private static final Logger log = LoggerFactory.getLogger(NpcAccessibilityTaggerParser.class);
    private static final NpcAccessibilityTaggerParser INSTANCE = new NpcAccessibilityTaggerParser();
    private final List<StandardEntry> entries = new ArrayList<StandardEntry>(10);

    public List<StandardEntry> getEntries() {
        return this.entries;
    }

    public List<StandardEntry> parse(NpcAccessibilityTaggerConfig config) {
        String input = config.endUserConfig();
        if (input == null || input.isEmpty()) {
            return null;
        }
        for (String entry : Text.fromCSV((String)input)) {
            try {
                String[] parts = entry.split(":");
                if (parts.length == 2) {
                    this.entries.add(new StandardEntry(Integer.parseInt(parts[0].trim()), parts[1].trim()));
                    continue;
                }
                if (parts.length != 3) continue;
                this.entries.add(new ExtendedEntry(Integer.parseInt(parts[0].trim()), parts[1].trim(), Color.decode(this.appendMissingPound(parts[2].trim()))));
            }
            catch (Exception e) {
                log.warn("Parse exception: \"" + entry + "\"\n" + e.getMessage());
            }
        }
        return this.entries;
    }

    private String appendMissingPound(String input) {
        if (!((String)input).startsWith("#")) {
            input = "#" + (String)input;
        }
        return input;
    }

    public static NpcAccessibilityTaggerParser getInstance() {
        return INSTANCE;
    }
}

