/*
 * Decompiled with CFR 0.152.
 */
package com.rymr.npcaccessibilitytagger;

import com.google.inject.Inject;
import com.rymr.npcaccessibilitytagger.ExtendedEntry;
import com.rymr.npcaccessibilitytagger.NpcAccessibilityTaggerConfig;
import com.rymr.npcaccessibilitytagger.NpcAccessibilityTaggerParser;
import com.rymr.npcaccessibilitytagger.StandardEntry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Optional;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.NPC;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpcAccessibilityTaggerOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(NpcAccessibilityTaggerOverlay.class);
    private final Client client;
    private final NpcAccessibilityTaggerConfig config;

    @Inject
    NpcAccessibilityTaggerOverlay(Client client, NpcAccessibilityTaggerConfig config) {
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.appendWordToNPC()) {
            for (NPC npc : this.client.getCachedNPCs()) {
                if (!this.shouldShow(npc)) continue;
                Optional<StandardEntry> matchingEntry = NpcAccessibilityTaggerParser.getInstance().getEntries().stream().filter(entry -> entry.getId() == npc.getId()).findAny();
                matchingEntry.ifPresent(standardEntry -> this.renderNpcOverlay(graphics, npc, (StandardEntry)standardEntry));
            }
        }
        return null;
    }

    private void renderNpcOverlay(Graphics2D graphics, NPC npc, StandardEntry entry) {
        Point textLocation = npc.getCanvasTextLocation(graphics, entry.getText(), npc.getLogicalHeight() + this.config.heightAboveNPC());
        graphics.setFont(this.config.fontStyle().getFont().deriveFont((float)this.config.fontSize()));
        if (textLocation != null) {
            if (this.config.enableCustomTextColor() && entry instanceof ExtendedEntry) {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)entry.getText(), (Color)((ExtendedEntry)entry).getColor());
            } else {
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)entry.getText(), (Color)this.config.defaultFontColor());
            }
        }
    }

    private boolean shouldShow(NPC npc) {
        if (npc == null || npc.getComposition() == null) {
            return false;
        }
        if (npc.getName() != null && (npc.getName().equals("") || npc.getName().equals("null"))) {
            return false;
        }
        return !this.isInvisible(npc.getModel());
    }

    private boolean isInvisible(Model model) {
        for (int value : model.getFaceColors3()) {
            if (value == -1) continue;
            return false;
        }
        return true;
    }
}

