/*
 * Decompiled with CFR 0.152.
 */
package com.rymr.npcaccessibilitytagger;

import com.rymr.npcaccessibilitytagger.FontOption;
import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="npcaccessibilitytagger")
public interface NpcAccessibilityTaggerConfig
extends Config {
    public static final String GROUP = "npcaccessibilitytagger";
    @ConfigSection(name="Text Style", description="The text style of NPC tagging", position=0)
    public static final String textStyleSection = "textStyleSection";
    @ConfigSection(name="Accessibility settings", description="Accessibility settings for NPC tagging", position=1)
    public static final String configSettingsSection = "configSettingsSection";
    @ConfigSection(name="Color Swatch", description="Useful for testing colors but not changing anything.", position=2)
    public static final String colorSwatchSection = "colorSwatchSection";

    @ConfigItem(position=5, keyName="defaultFontColor", name="Default Font Color", description="The default font color is used when a specific color isn't specified for a specific NPC.", section="textStyleSection")
    default public Color defaultFontColor() {
        return Color.WHITE;
    }

    @ConfigItem(position=0, keyName="appendWordToNPC", name="Append word to NPC", description="Configures whether or not NPC should have a word on it", section="textStyleSection")
    default public boolean appendWordToNPC() {
        return true;
    }

    @ConfigItem(position=1, keyName="heightAboveNPC", name="Height above NPC", description="Configures the height above NPC", section="textStyleSection")
    default public int heightAboveNPC() {
        return 40;
    }

    @ConfigItem(position=4, keyName="enableCustomTextColor", name="Enable custom text coloring", description="Configures whether or not the custom text color should be used", section="textStyleSection")
    default public boolean enableCustomTextColor() {
        return true;
    }

    @ConfigItem(position=2, keyName="fontStyle", name="Font Style", description="Select which font you wish to use", section="textStyleSection")
    default public FontOption fontStyle() {
        return FontOption.RUNESCAPE;
    }

    @ConfigItem(position=3, keyName="fontSize", name="Font Size", description="Select which font size you wish to use", section="textStyleSection")
    default public double fontSize() {
        return 15.0;
    }

    @ConfigItem(position=0, keyName="endUserConfig", name="Config settings", description="Config settings", section="configSettingsSection")
    default public String endUserConfig() {
        if (this.enableCustomTextColor()) {
            return "3101:Hans:#B40404";
        }
        return "3101:Hans";
    }

    @ConfigItem(position=0, keyName="colorSwatch", name="Color swatch", description="Color swatch for custom NPC tagging", section="colorSwatchSection")
    default public Color colorSwatch() {
        return Color.WHITE;
    }
}

