/*
 * Decompiled with CFR 0.152.
 */
package com.toggleitemstats.banking;

import com.google.inject.Provides;
import com.toggleitemstats.banking.BankItemStatsToggleConfig;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bank Item Stats Toggle")
public class BankItemStatsTogglePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BankItemStatsTogglePlugin.class);
    @Inject
    private Client client;
    @Inject
    private BankItemStatsToggleConfig config;
    @Inject
    private ConfigManager configManager;

    protected void startUp() throws Exception {
        log.info("Bank Item Stats Toggle started!");
    }

    protected void shutDown() throws Exception {
        log.info("Bank Item Stats Toggle stopped!");
    }

    @Subscribe
    void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 12) {
            if (this.config.equipmentStats()) {
                this.configManager.setConfiguration("itemstat", "equipmentStats", (Object)true);
            }
            if (this.config.consumableStats()) {
                this.configManager.setConfiguration("itemstat", "consumableStats", (Object)true);
            }
        }
    }

    @Subscribe
    void onWidgetClosed(WidgetClosed event) {
        if (event.getGroupId() == 12) {
            if (this.config.equipmentStats()) {
                this.configManager.setConfiguration("itemstat", "equipmentStats", (Object)false);
            }
            if (this.config.consumableStats()) {
                this.configManager.setConfiguration("itemstat", "consumableStats", (Object)false);
            }
        }
    }

    @Provides
    BankItemStatsToggleConfig provideConfig(ConfigManager configManager) {
        return (BankItemStatsToggleConfig)configManager.getConfig(BankItemStatsToggleConfig.class);
    }
}

