/*
 * Decompiled with CFR 0.152.
 */
package com.pmhighlight.ui;

import com.pmhighlight.PlayerSettings;
import com.pmhighlight.PmHighlightPlugin;
import com.pmhighlight.ui.AddPlayerSettingsPanel;
import com.pmhighlight.ui.PlayerSettingsPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.ImageUtil;

public class PmHighlightPluginPanel
extends PluginPanel {
    private static final ImageIcon ICON_ADD;
    private final JLabel addPlayerSettings = new JLabel(ICON_ADD);
    private final JPanel configView = new JPanel(new GridBagLayout());
    private final PluginErrorPanel noPlayerSettingsPanel = new PluginErrorPanel();
    private final JLabel title = new JLabel();
    private final PmHighlightPlugin plugin;
    private AddPlayerSettingsPanel addPlayerSettingsPanel;

    public PmHighlightPluginPanel(PmHighlightPlugin plugin) {
        this.plugin = plugin;
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setBorder(new EmptyBorder(1, 0, 10, 0));
        this.title.setText("PM Highlights");
        this.title.setForeground(Color.WHITE);
        northPanel.add((Component)this.title, "West");
        this.addPlayerSettings.setForeground(new Color(110, 225, 110));
        this.addPlayerSettings.setToolTipText("Add player highlight");
        this.addPlayerSettings.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                PmHighlightPluginPanel.this.showSettingCreationPanel(true);
            }
        });
        northPanel.add((Component)this.addPlayerSettings, "East");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.noPlayerSettingsPanel.setContent("PM Highlights", "No players configured");
        this.noPlayerSettingsPanel.setVisible(false);
        this.configView.add((Component)this.noPlayerSettingsPanel, constraints);
        ++constraints.gridy;
        this.addPlayerSettingsPanel = new AddPlayerSettingsPanel(plugin);
        this.addPlayerSettingsPanel.setVisible(false);
        this.configView.add((Component)this.addPlayerSettingsPanel, constraints);
        ++constraints.gridy;
        centerPanel.add((Component)this.configView, "Center");
        this.add(northPanel, "North");
        this.add(centerPanel, "Center");
    }

    public void rebuild() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.configView.removeAll();
        int playerSettingsCount = 0;
        HashMap<String, PlayerSettings> settingsHashMap = this.plugin.getPlayerSettingsMap();
        for (String key : settingsHashMap.keySet()) {
            PlayerSettingsPanel playerSettingsPanel = new PlayerSettingsPanel(this.plugin, key, settingsHashMap.get(key));
            this.configView.add((Component)playerSettingsPanel, constraints);
            ++constraints.gridy;
            ++playerSettingsCount;
        }
        this.noPlayerSettingsPanel.setVisible(playerSettingsCount == 0);
        this.title.setVisible(playerSettingsCount > 0);
        this.configView.add((Component)this.noPlayerSettingsPanel, constraints);
        ++constraints.gridy;
        this.configView.add((Component)this.addPlayerSettingsPanel, constraints);
        ++constraints.gridy;
        this.repaint();
        this.revalidate();
    }

    public void showSettingCreationPanel(boolean show) {
        if (show) {
            this.noPlayerSettingsPanel.setVisible(false);
        } else {
            this.rebuild();
        }
        this.addPlayerSettingsPanel.setVisible(show);
        this.addPlayerSettings.setVisible(!show);
        if (show) {
            this.addPlayerSettingsPanel.resetNameField();
        }
    }

    public AddPlayerSettingsPanel getAddPlayerSettingsPanel() {
        return this.addPlayerSettingsPanel;
    }

    static {
        BufferedImage icon = ImageUtil.loadImageResource(PmHighlightPluginPanel.class, (String)"/icon_add.png");
        ICON_ADD = new ImageIcon(icon);
    }
}

