/*
 * Decompiled with CFR 0.152.
 */
package com.pmhighlight.ui;

import com.pmhighlight.PlayerSettings;
import com.pmhighlight.PmHighlightPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.colorpicker.RuneliteColorPicker;

public class PlayerSettingsPanel
extends JPanel {
    private final PmHighlightPlugin plugin;
    private String playerName;
    private PlayerSettings settings;
    private boolean showDetails = false;
    private final JPanel detailsPanel;
    private final JLabel nameColorLabel = new JLabel();
    private final JLabel nameColorIndicator = new JLabel();
    private RuneliteColorPicker nameColorPicker;
    private JCheckBox nameHighlightSettingCheckbox;
    private final JLabel messageColorLabel = new JLabel();
    private final JLabel messageColorIndicator = new JLabel();
    private RuneliteColorPicker messageColorPicker;
    private JCheckBox messageHighlightSettingCheckbox;
    private final JLabel logColorLabel = new JLabel();
    private final JLabel logColorIndicator = new JLabel();
    private RuneliteColorPicker logColorPicker;
    private JCheckBox logHighlightSettingCheckbox;
    private JCheckBox notifyOnLoginCheckbox;

    public PlayerSettingsPanel(PmHighlightPlugin plugin, String playerName, PlayerSettings settings) {
        this.plugin = plugin;
        this.playerName = playerName;
        this.settings = settings;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 0, 5, 0));
        JPanel view = new JPanel(new BorderLayout());
        view.setBorder(new EmptyBorder(2, 2, 2, 2));
        view.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        final JPanel titlePanel = new JPanel();
        titlePanel.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        JLabel nameLabel = new JLabel(playerName);
        titlePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PlayerSettingsPanel.this.showDetails = !PlayerSettingsPanel.this.showDetails;
                PlayerSettingsPanel.this.detailsPanel.setVisible(PlayerSettingsPanel.this.showDetails);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                titlePanel.setBackground(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                titlePanel.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
            }
        });
        titlePanel.add((Component)nameLabel, "Center");
        this.detailsPanel = this.createDetailsJPanel(settings);
        this.detailsPanel.setVisible(false);
        view.add((Component)titlePanel, "North");
        view.add((Component)this.detailsPanel, "Center");
        this.add(view);
    }

    private JPanel createDetailsJPanel(PlayerSettings settings) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 5.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JLabel settingsTitle = new JLabel("Settings");
        settingsTitle.setBorder(new EmptyBorder(10, 5, 5, 5));
        panel.add((Component)settingsTitle, constraints);
        ++constraints.gridy;
        JPanel settingsPanel = this.createSettingsPanel();
        panel.add((Component)settingsPanel, constraints);
        ++constraints.gridy;
        JLabel colorTile = new JLabel("Colors");
        colorTile.setBorder(new EmptyBorder(10, 5, 5, 5));
        panel.add((Component)colorTile, constraints);
        ++constraints.gridy;
        JPanel colorPanel = this.createColorDetailsPanel();
        colorPanel.setBorder(new EmptyBorder(0, 5, 5, 5));
        panel.add((Component)colorPanel, constraints);
        ++constraints.gridy;
        JPanel actionsPanel = this.createActionPanel();
        actionsPanel.setBorder(new EmptyBorder(10, 5, 5, 5));
        panel.add((Component)actionsPanel, constraints);
        return panel;
    }

    private JPanel createSettingsPanel() {
        JPanel settingsPanel = new JPanel(new GridLayout(4, 1));
        settingsPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.nameHighlightSettingCheckbox = new JCheckBox("Highlight name");
        this.nameHighlightSettingCheckbox.setSelected(this.settings.isNameHighlightEnabled());
        this.nameHighlightSettingCheckbox.addItemListener(event -> {
            int state = event.getStateChange();
            boolean enabled = state == 1;
            this.settings.setNameHighlightEnabled(enabled);
            this.plugin.updatePlayerSettings(this.playerName, this.settings);
            this.plugin.updateConfig();
        });
        this.messageHighlightSettingCheckbox = new JCheckBox("Highlight message");
        this.messageHighlightSettingCheckbox.setSelected(this.settings.isMessageHighlightEnabled());
        this.messageHighlightSettingCheckbox.addItemListener(event -> {
            int state = event.getStateChange();
            boolean enabled = state == 1;
            this.settings.setMessageHighlightEnabled(enabled);
            this.plugin.updatePlayerSettings(this.playerName, this.settings);
            this.plugin.updateConfig();
        });
        this.logHighlightSettingCheckbox = new JCheckBox("Highlight log in/out message");
        this.logHighlightSettingCheckbox.setSelected(this.settings.isLogHighlightEnabled());
        this.logHighlightSettingCheckbox.addItemListener(event -> {
            int state = event.getStateChange();
            boolean enabled = state == 1;
            this.settings.setLogHighlightEnabled(enabled);
            this.plugin.updatePlayerSettings(this.playerName, this.settings);
            this.plugin.updateConfig();
        });
        this.notifyOnLoginCheckbox = new JCheckBox("Notify on login");
        this.notifyOnLoginCheckbox.setSelected(this.settings.isNotifyOnLogin());
        this.notifyOnLoginCheckbox.addItemListener(event -> {
            int state = event.getStateChange();
            boolean enabled = state == 1;
            this.settings.setNotifyOnLogin(enabled);
            this.plugin.updatePlayerSettings(this.playerName, this.settings);
            this.plugin.updateConfig();
        });
        settingsPanel.add(this.nameHighlightSettingCheckbox);
        settingsPanel.add(this.messageHighlightSettingCheckbox);
        settingsPanel.add(this.logHighlightSettingCheckbox);
        settingsPanel.add(this.notifyOnLoginCheckbox);
        return settingsPanel;
    }

    private JPanel createColorDetailsPanel() {
        JPanel colorPanel = new JPanel(new GridLayout(3, 2, 8, 8));
        colorPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.nameColorLabel.setText("Name:");
        this.nameColorIndicator.setText(this.settings.getNameColor());
        this.nameColorIndicator.setForeground(Color.WHITE);
        this.nameColorIndicator.setBackground(Color.decode(this.settings.getNameColor()));
        this.nameColorIndicator.setPreferredSize(new Dimension(2, 2));
        this.nameColorIndicator.setOpaque(true);
        this.nameColorIndicator.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PlayerSettingsPanel.this.openColorPicker(PlayerSettingsPanel.this.nameColorPicker, PlayerSettingsPanel.this.nameColorLabel, PlayerSettingsPanel.this.nameColorIndicator, "name");
            }
        });
        colorPanel.add(this.nameColorLabel);
        colorPanel.add(this.nameColorIndicator);
        this.messageColorLabel.setText("Message:");
        this.messageColorIndicator.setText(this.settings.getMessageColor());
        this.messageColorIndicator.setForeground(Color.WHITE);
        this.messageColorIndicator.setBackground(Color.decode(this.settings.getMessageColor()));
        this.messageColorIndicator.setOpaque(true);
        this.messageColorIndicator.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PlayerSettingsPanel.this.openColorPicker(PlayerSettingsPanel.this.messageColorPicker, PlayerSettingsPanel.this.messageColorLabel, PlayerSettingsPanel.this.messageColorIndicator, "message");
            }
        });
        colorPanel.add(this.messageColorLabel);
        colorPanel.add(this.messageColorIndicator);
        this.logColorLabel.setText("Log message:");
        this.logColorIndicator.setText(this.settings.getLogColor());
        this.logColorIndicator.setForeground(Color.WHITE);
        this.logColorIndicator.setBackground(Color.decode(this.settings.getLogColor()));
        this.logColorIndicator.setOpaque(true);
        this.logColorIndicator.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PlayerSettingsPanel.this.openColorPicker(PlayerSettingsPanel.this.logColorPicker, PlayerSettingsPanel.this.logColorLabel, PlayerSettingsPanel.this.logColorIndicator, "log");
            }
        });
        colorPanel.add(this.logColorLabel);
        colorPanel.add(this.logColorIndicator);
        return colorPanel;
    }

    private JPanel createActionPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 2, 8, 8));
        panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(l -> {
            int confirm = JOptionPane.showConfirmDialog(this, "Are you sure you want to reset the settings for this player?", "Warning", 2);
            if (confirm == 0) {
                Color defaultColor = this.plugin.getDefaultColor();
                String defaultColorhex = this.plugin.colorToHexString(defaultColor);
                boolean nameEnabled = this.plugin.getDefaultNameHighlightSetting();
                boolean messageEnabled = this.plugin.getDefaultMessageHighlightSetting();
                boolean logEnabled = this.plugin.getDefaultLogNHighlightSetting();
                this.settings.setNameColor(defaultColorhex);
                this.nameColorIndicator.setText(defaultColorhex);
                this.nameColorIndicator.setBackground(defaultColor);
                this.settings.setNameHighlightEnabled(nameEnabled);
                this.nameHighlightSettingCheckbox.setSelected(nameEnabled);
                this.settings.setMessageColor(defaultColorhex);
                this.messageColorIndicator.setText(defaultColorhex);
                this.messageColorIndicator.setBackground(defaultColor);
                this.settings.setMessageHighlightEnabled(messageEnabled);
                this.messageHighlightSettingCheckbox.setSelected(messageEnabled);
                this.settings.setLogColor(defaultColorhex);
                this.logColorIndicator.setText(defaultColorhex);
                this.logColorIndicator.setBackground(defaultColor);
                this.settings.setLogHighlightEnabled(logEnabled);
                this.logHighlightSettingCheckbox.setSelected(logEnabled);
                this.plugin.updatePlayerSettings(this.playerName, this.settings);
                this.plugin.updateConfig();
            }
        });
        JButton removeButton = new JButton("Remove");
        removeButton.addActionListener(l -> {
            int confirm = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the settings for this player?", "Warning", 2);
            if (confirm == 0) {
                this.plugin.removePlayerSettings(this.playerName);
                this.plugin.updateConfig();
            }
        });
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.add(resetButton);
        panel.add(removeButton);
        return panel;
    }

    public void openColorPicker(RuneliteColorPicker colorPicker, JLabel label, JLabel indicatorLabel, String setting) {
        colorPicker = this.plugin.getColorPickerManager().create(SwingUtilities.windowForComponent(this), Color.decode(indicatorLabel.getText()), "Pick a color", true);
        colorPicker.setLocation(this.getLocationOnScreen());
        colorPicker.setOnColorChange(selectedColor -> {
            String hex = this.plugin.colorToHexString((Color)selectedColor);
            indicatorLabel.setText(hex);
            indicatorLabel.setBackground((Color)selectedColor);
            switch (setting) {
                case "name": {
                    this.settings.setNameColor(hex);
                    break;
                }
                case "message": {
                    this.settings.setMessageColor(hex);
                    break;
                }
                case "log": {
                    this.settings.setLogColor(hex);
                    break;
                }
            }
        });
        colorPicker.setOnClose(c -> {
            this.plugin.updatePlayerSettings(this.playerName, this.settings);
            this.plugin.updateConfig();
        });
        colorPicker.setVisible(true);
    }
}

