/*
 * Decompiled with CFR 0.152.
 */
package com.pmhighlight.ui;

import com.pmhighlight.PmHighlightPlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.components.FlatTextField;
import net.runelite.client.ui.components.colorpicker.RuneliteColorPicker;

public class AddPlayerSettingsPanel
extends JPanel {
    private final PmHighlightPlugin plugin;
    private final JLabel nameInputLabel = new JLabel();
    private final FlatTextField nameInputField = new FlatTextField();
    private final JLabel nameColorLabel = new JLabel();
    private final JLabel nameColorIndicator = new JLabel();
    private RuneliteColorPicker nameColorPicker;
    private final JLabel messageColorLabel = new JLabel();
    private final JLabel messageColorIndicator = new JLabel();
    private RuneliteColorPicker messageColorPicker;
    private final JLabel logColorLabel = new JLabel();
    private final JLabel logColorIndicator = new JLabel();
    private RuneliteColorPicker logColorPicker;

    public AddPlayerSettingsPanel(PmHighlightPlugin plugin) {
        this.plugin = plugin;
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(5, 0, 5, 0));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 5.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        JPanel titlePanel = new JPanel();
        JLabel title = new JLabel("New player highlight");
        titlePanel.add(title);
        titlePanel.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        titlePanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.add((Component)titlePanel, constraints);
        ++constraints.gridy;
        JPanel inputPanel = new JPanel(new GridLayout(4, 2, 8, 8));
        inputPanel.setBorder(new EmptyBorder(10, 5, 5, 5));
        inputPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.nameInputLabel.setText("Player name:");
        this.nameInputField.setBackground(ColorScheme.DARK_GRAY_COLOR);
        inputPanel.add(this.nameInputLabel);
        inputPanel.add((Component)this.nameInputField);
        this.nameColorLabel.setText("Name color:");
        this.nameColorIndicator.setText(plugin.colorToHexString(plugin.getDefaultColor()));
        this.nameColorIndicator.setForeground(Color.WHITE);
        this.nameColorIndicator.setBackground(plugin.getDefaultColor());
        this.nameColorIndicator.setOpaque(true);
        this.nameColorIndicator.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AddPlayerSettingsPanel.this.openColorPicker(AddPlayerSettingsPanel.this.nameColorPicker, AddPlayerSettingsPanel.this.nameColorIndicator);
            }
        });
        inputPanel.add(this.nameColorLabel);
        inputPanel.add(this.nameColorIndicator);
        this.messageColorLabel.setText("Message color:");
        this.messageColorIndicator.setText(plugin.colorToHexString(plugin.getDefaultColor()));
        this.messageColorIndicator.setForeground(Color.WHITE);
        this.messageColorIndicator.setBackground(plugin.getDefaultColor());
        this.messageColorIndicator.setOpaque(true);
        this.messageColorIndicator.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AddPlayerSettingsPanel.this.openColorPicker(AddPlayerSettingsPanel.this.messageColorPicker, AddPlayerSettingsPanel.this.messageColorIndicator);
            }
        });
        inputPanel.add(this.messageColorLabel);
        inputPanel.add(this.messageColorIndicator);
        this.logColorLabel.setText("Log message color:");
        this.logColorIndicator.setText(plugin.colorToHexString(plugin.getDefaultColor()));
        this.logColorIndicator.setForeground(Color.WHITE);
        this.logColorIndicator.setBackground(plugin.getDefaultColor());
        this.logColorIndicator.setOpaque(true);
        this.logColorIndicator.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AddPlayerSettingsPanel.this.openColorPicker(AddPlayerSettingsPanel.this.logColorPicker, AddPlayerSettingsPanel.this.logColorIndicator);
            }
        });
        inputPanel.add(this.logColorLabel);
        inputPanel.add(this.logColorIndicator);
        this.add((Component)inputPanel, constraints);
        ++constraints.gridy;
        JPanel actionsPanel = this.createActionsPanel();
        actionsPanel.setBorder(new EmptyBorder(10, 5, 5, 5));
        this.add((Component)actionsPanel, constraints);
    }

    private JPanel createActionsPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 8, 8));
        buttonPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(l -> this.plugin.setSettingsCreationPanelState(false));
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(l -> {
            this.plugin.createPlayerSettings(this.nameInputField.getText(), this.nameColorIndicator.getText(), this.messageColorIndicator.getText(), this.logColorIndicator.getText());
            this.plugin.updateConfig();
            this.plugin.setSettingsCreationPanelState(false);
        });
        buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        buttonPanel.add(cancelButton);
        buttonPanel.add(saveButton);
        return buttonPanel;
    }

    public void openColorPicker(RuneliteColorPicker colorPicker, JLabel indicatorLabel) {
        colorPicker = this.plugin.getColorPickerManager().create(SwingUtilities.windowForComponent(this), Color.decode(indicatorLabel.getText()), "Choose a color", true);
        colorPicker.setLocation(this.getLocationOnScreen());
        colorPicker.setOnColorChange(selectedColor -> {
            indicatorLabel.setText(this.plugin.colorToHexString((Color)selectedColor));
            indicatorLabel.setBackground((Color)selectedColor);
        });
        colorPicker.setVisible(true);
    }

    public void resetNameField() {
        this.nameInputField.setText("");
    }
}

