/*
 * Decompiled with CFR 0.152.
 */
package com.pmhighlight;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import com.pmhighlight.PlayerSettings;
import com.pmhighlight.PmHighlightConfig;
import com.pmhighlight.ui.PmHighlightPluginPanel;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.MessageNode;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.colorpicker.ColorPickerManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;

@PluginDescriptor(name="PM Highlight", description="Highlight private messages in different colors for certain players", tags={"highlight", "color", "private", "chat", "friends"})
public class PmHighlightPlugin
extends Plugin {
    @Inject
    protected ClientToolbar clientToolbar;
    protected NavigationButton navigationButton;
    protected PmHighlightPluginPanel pluginPanel;
    @Inject
    private PmHighlightConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Notifier notifier;
    @Inject
    private Gson gson;
    private final HashMap<String, PlayerSettings> playerSettingsMap = new HashMap();
    @Inject
    private ColorPickerManager colorPickerManager;
    private static final String CONFIG_GROUP_NAME = "pmhighlight";
    private static final String CONFIG_KEY = "playersettings";
    private static final String LOG_REGEX = "(?<name>.+)\\shas\\slogged\\s(?<method>in|out).";
    private static final String NAME_REGEX = "(?<icon>\\<img=\\d+>)?(?<name>.*)";
    private Pattern logPattern;
    private Pattern namePattern;

    @Provides
    PmHighlightConfig getConfig(ConfigManager configManager) {
        return (PmHighlightConfig)configManager.getConfig(PmHighlightConfig.class);
    }

    protected void startUp() throws Exception {
        this.logPattern = Pattern.compile(LOG_REGEX);
        this.namePattern = Pattern.compile(NAME_REGEX);
        this.pluginPanel = new PmHighlightPluginPanel(this);
        String configJson = this.configManager.getConfiguration(CONFIG_GROUP_NAME, CONFIG_KEY);
        this.loadConfig(configJson);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/icon_marker.png");
        this.pluginPanel.rebuild();
        this.navigationButton = NavigationButton.builder().tooltip("PM Highlights").icon(icon).priority(5).panel((PluginPanel)this.pluginPanel).build();
        this.clientToolbar.addNavigation(this.navigationButton);
    }

    protected void shutDown() {
        this.updateConfig();
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.playerSettingsMap.clear();
        this.pluginPanel = null;
        this.navigationButton = null;
    }

    @Subscribe(priority=1.0f)
    public void onChatMessage(ChatMessage message) {
        MessageNode messageNode;
        Matcher logMatcher;
        ChatMessageType type = message.getType();
        if (type == ChatMessageType.LOGINLOGOUTNOTIFICATION && (logMatcher = this.logPattern.matcher((messageNode = message.getMessageNode()).getValue())).find() && logMatcher.group("name") != null) {
            String playerName = logMatcher.group("name");
            if (this.playerSettingsMap.containsKey(playerName = Text.toJagexName((String)playerName))) {
                PlayerSettings settings = this.playerSettingsMap.get(playerName);
                if (settings.isLogHighlightEnabled()) {
                    Color color = Color.decode(settings.getLogColor());
                    messageNode.setValue(this.wrapWithColorTags(messageNode.getValue(), color));
                }
                if (logMatcher.group("method").equals("in") && settings.isNotifyOnLogin()) {
                    this.notifier.notify(playerName + " has logged in");
                }
            }
        }
        if (type == ChatMessageType.PRIVATECHAT || type == ChatMessageType.PRIVATECHATOUT) {
            messageNode = message.getMessageNode();
            String messageName = Text.toJagexName((String)messageNode.getName());
            Matcher nameMatcher = this.namePattern.matcher(messageName);
            String icon = "";
            String playerName = "";
            if (nameMatcher.find()) {
                if (nameMatcher.group("icon") != null) {
                    icon = nameMatcher.group("icon");
                }
                if (nameMatcher.group("name") != null) {
                    playerName = nameMatcher.group("name");
                }
                if (this.playerSettingsMap.containsKey(playerName)) {
                    PlayerSettings settings = this.playerSettingsMap.get(playerName);
                    if (settings.isNameHighlightEnabled()) {
                        Color nameColor = Color.decode(settings.getNameColor());
                        Object coloredName = this.wrapWithColorTags(playerName, nameColor);
                        if (!icon.isEmpty()) {
                            coloredName = icon + (String)coloredName;
                        }
                        messageNode.setName(this.wrapWithColorTags((String)coloredName, nameColor));
                    }
                    if (settings.isMessageHighlightEnabled()) {
                        Color messageColor = Color.decode(settings.getMessageColor());
                        messageNode.setValue(this.wrapWithColorTags(messageNode.getValue(), messageColor));
                    }
                }
            }
        }
    }

    private String wrapWithColorTags(String text, Color color) {
        return ColorUtil.wrapWithColorTag((String)text.replace("</col>", ColorUtil.colorTag((Color)color)), (Color)color);
    }

    public Color getDefaultColor() {
        return this.config.defaultColor();
    }

    public boolean getDefaultNameHighlightSetting() {
        return this.config.highlightUsernameDefault();
    }

    public boolean getDefaultMessageHighlightSetting() {
        return this.config.highlightMessageDefault();
    }

    public boolean getDefaultLogNHighlightSetting() {
        return this.config.highlightLoggedInOutDefault();
    }

    public boolean getDefaultNotifyOnLogin() {
        return this.config.notifyOnLogin();
    }

    public String colorToHexString(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChangedEvent) {
        if (configChangedEvent.getGroup().equals(CONFIG_GROUP_NAME) && configChangedEvent.getKey().equals(CONFIG_KEY)) {
            this.loadConfig(configChangedEvent.getNewValue());
        }
    }

    public void setSettingsCreationPanelState(boolean show) {
        this.pluginPanel.showSettingCreationPanel(show);
    }

    public void updateConfig() {
        if (this.playerSettingsMap.isEmpty()) {
            this.configManager.unsetConfiguration(CONFIG_GROUP_NAME, CONFIG_KEY);
        } else {
            String json = this.gson.toJson(this.playerSettingsMap);
            this.configManager.setConfiguration(CONFIG_GROUP_NAME, CONFIG_KEY, json);
        }
    }

    private void loadConfig(String json) {
        this.playerSettingsMap.clear();
        Map list = (Map)this.gson.fromJson(json, new TypeToken<HashMap<String, PlayerSettings>>(){}.getType());
        if (list != null) {
            for (String key : list.keySet()) {
                this.playerSettingsMap.put(key, (PlayerSettings)list.get(key));
            }
        }
    }

    public void createPlayerSettings(String name, String nameColor, String messageColor, String logColor) {
        PlayerSettings settings = new PlayerSettings();
        settings.setNameColor(nameColor);
        settings.setMessageColor(messageColor);
        settings.setLogColor(logColor);
        settings.setNameHighlightEnabled(this.getDefaultNameHighlightSetting());
        settings.setMessageHighlightEnabled(this.getDefaultMessageHighlightSetting());
        settings.setLogHighlightEnabled(this.getDefaultLogNHighlightSetting());
        settings.setNotifyOnLogin(this.getDefaultNotifyOnLogin());
        this.playerSettingsMap.put(name, settings);
        this.pluginPanel.rebuild();
    }

    public void updatePlayerSettings(String name, PlayerSettings settings) {
        this.playerSettingsMap.put(name, settings);
    }

    public void removePlayerSettings(String name) {
        if (this.playerSettingsMap.containsKey(name)) {
            this.playerSettingsMap.remove(name);
            this.pluginPanel.rebuild();
        }
    }

    public HashMap<String, PlayerSettings> getPlayerSettingsMap() {
        return this.playerSettingsMap;
    }

    public ColorPickerManager getColorPickerManager() {
        return this.colorPickerManager;
    }
}

