/*
 * Decompiled with CFR 0.152.
 */
package com.fakeProtection;

import com.fakeProtection.FakeProtectionConfig;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.SkullIcon;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneScapeProfileType;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="DMM Fake Protection")
public class FakeProtectionPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FakeProtectionPlugin.class);
    @Inject
    private Client client;
    @Inject
    private FakeProtectionConfig config;
    private RuneScapeProfileType profileType;
    private int tickCounter = 0;
    private int startTime;
    private int displayedTime;
    public final int TIMER_WIDGET = 5898291;
    public final int LEVEL_WIDGET = 5898289;

    protected void startUp() throws Exception {
        this.tickCounter = 0;
        this.profileType = RuneScapeProfileType.getCurrent((Client)this.client);
        this.startTime = this.displayedTime = this.config.timeDisplayed();
    }

    protected void shutDown() throws Exception {
        Widget wi = this.client.getWidget(5898289);
        if (wi != null) {
            wi.setHidden(false);
        }
        if ((wi = this.client.getWidget(5898291)) != null) {
            wi.setHidden(true);
        }
    }

    @Subscribe
    protected void onBeforeRender(BeforeRender event) {
        switch (this.profileType) {
            case DEADMAN: 
            case DEADMAN_REBORN: {
                this.Update();
            }
        }
    }

    @Subscribe
    protected void onGameTick(GameTick tick) {
        if (this.tickCounter++ > 100) {
            this.tickCounter = 0;
            if (this.config.decreaseTime()) {
                if (this.displayedTime-- <= this.config.resetTime()) {
                    this.displayedTime = this.config.timeDisplayed();
                }
            } else {
                this.displayedTime = this.config.timeDisplayed();
            }
        }
    }

    @Subscribe
    protected void onGameStateChanged(GameStateChanged gameStateChanged) {
        this.profileType = RuneScapeProfileType.getCurrent((Client)this.client);
    }

    @Subscribe
    protected void onConfigChanged(ConfigChanged configChanged) {
        if (this.startTime != this.config.timeDisplayed()) {
            this.tickCounter = 0;
            this.startTime = this.displayedTime = this.config.timeDisplayed();
        }
    }

    @Provides
    FakeProtectionConfig provideConfig(ConfigManager configManager) {
        return (FakeProtectionConfig)configManager.getConfig(FakeProtectionConfig.class);
    }

    private void Update() {
        Widget wi = this.client.getWidget(WidgetInfo.PVP_WILDERNESS_LEVEL);
        if (wi != null) {
            wi.setText("Protection");
            wi.deleteAllChildren();
        }
        if ((wi = this.client.getWidget(5898291)) != null) {
            SkullIcon currentIcon = this.client.getLocalPlayer().getSkullIcon();
            if (this.config.skullTimer() && currentIcon != null && currentIcon != SkullIcon.SKULL_FIGHT_PIT) {
                String curTime = wi.getText();
                if (curTime.length() > 4) {
                    wi.setText(curTime.substring(curTime.length() - 5));
                }
            } else {
                wi.setText(Integer.toString(this.displayedTime) + "min");
            }
            wi.setHidden(false);
        }
        if ((wi = this.client.getWidget(5898289)) != null) {
            wi.setHidden(true);
        }
    }
}

