/*
 * Decompiled with CFR 0.152.
 */
package com.globalchat;

import com.globalchat.AblyManager;
import com.globalchat.GlobalChatConfig;
import com.google.inject.Provides;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import net.runelite.api.ChatLineBuffer;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.WorldChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="World Global Chat", description="Talk anywhere!", tags={"chat"})
public class GlobalChatPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GlobalChatPlugin.class);
    @Inject
    private AblyManager ablyManager;
    @Inject
    private Client client;
    private final HashMap<String, ArrayList<String>> previousMessages = new HashMap();
    @Inject
    @Named(value="developerMode")
    private boolean developerMode;

    protected void startUp() throws Exception {
        this.ablyManager.startConnection();
        this.ablyManager.connectToGlobal();
        this.ablyManager.connectToRegion(String.valueOf(this.client.getWorld()));
    }

    protected void shutDown() throws Exception {
        this.ablyManager.closeConnection();
    }

    @Subscribe
    public void onWorldChanged(WorldChanged worldChanged) {
        this.ablyManager.closeConnection();
        this.ablyManager.startConnection();
        this.ablyManager.connectToGlobal();
        this.ablyManager.connectToRegion(String.valueOf(this.client.getWorld()));
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String cleanedName = Text.sanitize((String)event.getName());
        String cleanedMessage = Text.removeTags((String)event.getMessage());
        boolean isPublic = event.getType().equals((Object)ChatMessageType.PUBLICCHAT);
        boolean isLocalPlayerSendingMessage = cleanedName.equals(this.client.getLocalPlayer().getName());
        if (isPublic && isLocalPlayerSendingMessage) {
            this.ablyManager.shouldShowMessge(cleanedName, cleanedMessage, true);
            this.ablyManager.publishMessage(cleanedMessage, false, "");
        } else if (event.getType().equals((Object)ChatMessageType.PRIVATECHATOUT)) {
            this.ablyManager.shouldShowMessge(this.client.getLocalPlayer().getName(), cleanedMessage, true);
            this.ablyManager.publishMessage(cleanedMessage, true, cleanedName);
        } else if (event.getType().equals((Object)ChatMessageType.PRIVATECHAT) && !this.ablyManager.shouldShowMessge(cleanedName, cleanedMessage, true)) {
            ChatLineBuffer lineBuffer = (ChatLineBuffer)this.client.getChatLineMap().get(ChatMessageType.PRIVATECHAT.getType());
            lineBuffer.removeMessageNode(event.getMessageNode());
        } else {
            this.ablyManager.shouldShowMessge(cleanedName, cleanedMessage, true);
        }
    }

    @Provides
    GlobalChatConfig provideConfig(ConfigManager configManager) {
        return (GlobalChatConfig)configManager.getConfig(GlobalChatConfig.class);
    }

    public HashMap<String, ArrayList<String>> getPreviousMessages() {
        return this.previousMessages;
    }

    public boolean isDeveloperMode() {
        return this.developerMode;
    }
}

