/*
 * Decompiled with CFR 0.152.
 */
package com.globalchat;

import com.globalchat.GlobalChatConfig;
import com.globalchat.GlobalChatMessage;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.ably.lib.realtime.AblyRealtime;
import io.ably.lib.realtime.Channel;
import io.ably.lib.realtime.ChannelState;
import io.ably.lib.realtime.CompletionListener;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.ClientOptions;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Message;
import io.ably.lib.util.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Player;
import net.runelite.api.WorldType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AblyManager {
    private static final Logger log = LoggerFactory.getLogger(AblyManager.class);
    public static final int CYCLES_PER_GAME_TICK = 30;
    private static final int OVERHEAD_TEXT_TICK_TIMEOUT = 5;
    private static final int CYCLES_FOR_OVERHEAD_TEXT = 150;
    private final Client client;
    @Inject
    Gson gson;
    private final Map<String, String> previousMessages = new HashMap<String, String>();
    private final String CHANNEL_NAME_PREFIX = "globalchat";
    private boolean changingChannels;
    @Inject
    ChatMessageManager chatMessageManager;
    private final GlobalChatConfig config;
    private AblyRealtime ablyRealtime;
    private Channel ablyRegionChannel;
    private Channel ablyGlobalChannel;

    @Inject
    public AblyManager(Client client, GlobalChatConfig config) {
        this.client = client;
        this.config = config;
    }

    public void startConnection() {
        this.setupAblyInstances();
    }

    public void closeConnection() {
        this.ablyRealtime.close();
        this.ablyRealtime = null;
        this.ablyRegionChannel = null;
        this.ablyGlobalChannel = null;
    }

    public void publishMessage(String message, Boolean global, String to) {
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        if (this.ablyRegionChannel == null && !global.booleanValue()) {
            return;
        }
        if (this.ablyGlobalChannel == null && global.booleanValue()) {
            return;
        }
        try {
            JsonObject msg = JsonUtils.object().add("symbol", this.getAccountIcon()).add("username", this.client.getLocalPlayer().getName()).add("message", message).add("global", global.toString()).add("to", to).toJson();
            if (global.booleanValue()) {
                this.ablyGlobalChannel.publish("event", msg);
            } else {
                this.ablyRegionChannel.publish("event", msg);
            }
        }
        catch (AblyException err) {
            System.out.println(err.getMessage());
        }
    }

    private void handleMessage(Message message) {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.handleAblyMessage(message);
        }
    }

    private void handleAblyMessage(Message message) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        GlobalChatMessage msg = (GlobalChatMessage)this.gson.fromJson((JsonElement)message.data, GlobalChatMessage.class);
        String username = msg.username;
        String receivedMsg = Text.removeTags((String)msg.message);
        if (!this.shouldShowMessge(username, receivedMsg, false)) {
            return;
        }
        ChatMessageBuilder chatMessageBuilder = new ChatMessageBuilder().append(receivedMsg);
        if (username.length() > 12) {
            return;
        }
        if (msg.global.equals("true") && !username.equals(this.client.getLocalPlayer().getName()) && msg.to.equals(this.client.getLocalPlayer().getName())) {
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.PRIVATECHAT).name(msg.symbol + msg.username).runeLiteFormattedMessage(chatMessageBuilder.build()).build());
        } else if (msg.global.equals("false")) {
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.PUBLICCHAT).name(msg.symbol + msg.username).runeLiteFormattedMessage(chatMessageBuilder.build()).build());
            for (Player player : this.client.getPlayers()) {
                if (player == null || player.getName() == null || !username.equals(player.getName())) continue;
                player.setOverheadText(receivedMsg);
                player.setOverheadCycle(150);
                return;
            }
        }
    }

    public boolean shouldShowMessge(String name, String message, Boolean set) {
        String prevMessage = this.previousMessages.get(name);
        if (message.equals(prevMessage)) {
            return false;
        }
        if (set.booleanValue()) {
            this.previousMessages.put(name, message);
        }
        return true;
    }

    private void setupAblyInstances() {
        try {
            ClientOptions clientOptions = new ClientOptions();
            clientOptions.key = "ubLi2Q.kA6NlA:djTnpbYSimiCtMw-5bhaOXKmDB3hd-GWsyyPtZHvh3k";
            this.ablyRealtime = new AblyRealtime(clientOptions);
        }
        catch (AblyException e) {
            e.printStackTrace();
        }
    }

    public void connectToGlobal() {
        Boolean global = true;
        String newChannelName = "globalchat:global";
        if (this.changingChannels) {
            return;
        }
        if (this.ablyGlobalChannel != null && this.ablyGlobalChannel.name.equals(newChannelName)) {
            if (this.ablyGlobalChannel.state == ChannelState.detached) {
                this.subscribeToChannel(global);
            }
            return;
        }
        this.changingChannels = true;
        if (this.ablyGlobalChannel == null) {
            this.ablyGlobalChannel = this.ablyRealtime.channels.get(newChannelName);
            this.subscribeToChannel(global);
            return;
        }
        try {
            this.ablyGlobalChannel.unsubscribe();
            this.ablyGlobalChannel.detach(this.detatchListener(newChannelName, global));
        }
        catch (AblyException err) {
            this.changingChannels = false;
            System.err.println(err.getMessage());
        }
    }

    public void connectToRegion(String world) {
        Boolean global = false;
        String newChannelName = "globalchat:" + world + ":global";
        if (this.changingChannels) {
            return;
        }
        if (this.ablyRegionChannel != null && this.ablyRegionChannel.name.equals(newChannelName)) {
            if (this.ablyRegionChannel.state == ChannelState.detached) {
                this.subscribeToChannel(global);
            }
            return;
        }
        this.changingChannels = true;
        if (this.ablyRegionChannel == null) {
            this.ablyRegionChannel = this.ablyRealtime.channels.get(newChannelName);
            this.subscribeToChannel(global);
            return;
        }
        try {
            this.ablyRegionChannel.unsubscribe();
            this.ablyRegionChannel.detach(this.detatchListener(newChannelName, global));
        }
        catch (AblyException err) {
            this.changingChannels = false;
            System.err.println(err.getMessage());
        }
    }

    public CompletionListener detatchListener(final String newChannelName, final Boolean global) {
        return new CompletionListener(){

            @Override
            public void onSuccess() {
                if (global.booleanValue()) {
                    AblyManager.this.ablyGlobalChannel = AblyManager.this.ablyRealtime.channels.get(newChannelName);
                } else {
                    AblyManager.this.ablyRegionChannel = AblyManager.this.ablyRealtime.channels.get(newChannelName);
                }
                AblyManager.this.subscribeToChannel(global);
            }

            @Override
            public void onError(ErrorInfo reason) {
                System.err.println(reason.message);
                AblyManager.this.changingChannels = false;
            }
        };
    }

    public void disconnectFromRegions() {
        if (this.ablyRegionChannel != null && this.ablyRegionChannel.state == ChannelState.attached) {
            try {
                this.ablyRegionChannel.unsubscribe();
                this.ablyRegionChannel.detach();
            }
            catch (AblyException err) {
                System.err.println(err.getMessage());
            }
        }
        if (this.ablyGlobalChannel != null && this.ablyGlobalChannel.state == ChannelState.attached) {
            try {
                this.ablyGlobalChannel.unsubscribe();
                this.ablyGlobalChannel.detach();
            }
            catch (AblyException err) {
                System.err.println(err.getMessage());
            }
        }
    }

    private void subscribeToChannel(Boolean global) {
        try {
            if (global.booleanValue()) {
                this.ablyGlobalChannel.subscribe(this::handleMessage);
            } else {
                this.ablyRegionChannel.subscribe(this::handleMessage);
            }
        }
        catch (AblyException err) {
            System.err.println(err.getMessage());
        }
        this.changingChannels = false;
    }

    private String getAccountIcon() {
        if (this.client.getWorldType().contains(WorldType.TOURNAMENT_WORLD)) {
            return "<img=33>";
        }
        switch (this.client.getAccountType()) {
            case IRONMAN: {
                return "<img=2>";
            }
            case HARDCORE_IRONMAN: {
                return "<img=10>";
            }
            case ULTIMATE_IRONMAN: {
                return "<img=3>";
            }
        }
        return "";
    }
}

